/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.spring.namespace.simple;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.jboss.windup.hint.RegexPatternHintProcessor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class RegexHintBeanParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanBuilder = BeanDefinitionBuilder.rootBeanDefinition(RegexPatternHintProcessor.class);
        beanBuilder.addPropertyValue("regexPattern", (Object)element.getAttribute("regex"));
        if (element.hasAttribute("hint")) {
            beanBuilder.addPropertyValue("hint", (Object)element.getAttribute("hint"));
        } else {
            String markdown = element.getTextContent();
            String[] lines = markdown.split("\\r?\\n");
            StringBuilder markdownRebuilder = new StringBuilder();
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if ((line = StringUtils.trim((String)line)) != null) {
                    markdownRebuilder.append(line);
                }
                if (i >= lines.length - 1) continue;
                markdownRebuilder.append(SystemUtils.LINE_SEPARATOR);
            }
            beanBuilder.addPropertyValue("hint", (Object)markdownRebuilder.toString());
        }
        if (element.hasAttribute("effort")) {
            beanBuilder.addPropertyValue("effort", (Object)Integer.parseInt(element.getAttribute("effort")));
        }
        return beanBuilder.getBeanDefinition();
    }
}

