/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.logging;

import java.io.IOException;
import java.net.URL;
import org.jboss.as.controller.client.helpers.domain.DeploymentAction;
import org.jboss.as.controller.client.helpers.domain.RollbackCancelledException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
@MessageLogger(projectCode="WFLYCC", length=4)
public interface ControllerClientLogger
extends BasicLogger {
    public static final ControllerClientLogger ROOT_LOGGER;

    @Message(id=1, value="Cannot add deployment actions after starting creation of a rollout plan")
    public IllegalStateException cannotAddDeploymentAction();

    @Message(id=2, value="Cannot add deployment actions after starting creation of a rollout plan")
    public IllegalStateException cannotAddDeploymentActionsAfterStart();

    @Message(id=3, value="Cannot convert %s to %s")
    public String cannotConvert(String var1, String var2);

    @Message(id=4, value="Cannot derive a deployment name from %s -- use an overloaded method variant that takes a 'name' parameter")
    public IllegalArgumentException cannotDeriveDeploymentName(URL var1);

    @Message(id=5, value="Cannot use a DeploymentPlan not created by this manager")
    public IllegalArgumentException cannotUseDeploymentPlan();

    @Message(id=6, value="Channel closed")
    public IOException channelClosed(@Cause IOException var1);

    @Message(id=7, value="Deployment with name %s already present in the domain")
    public String domainDeploymentAlreadyExists(String var1);

    @Message(id=8, value="failed")
    public String failed();

    @Message(id=9, value="Global rollback is not compatible with a server restart")
    public IllegalStateException globalRollbackNotCompatible();

    @Message(id=10, value="Graceful shutdown already configured with a timeout of %d ms")
    public IllegalStateException gracefulShutdownAlreadyConfigured(long var1);

    @Message(id=11, value="Only one version of deployment with a given unique name can exist in the domain. The deployment plan specified that a new version of deployment %s replace an existing deployment with the same unique name, but did not apply the replacement to all server groups. Missing server groups were: %s")
    public String incompleteDeploymentReplace(String var1, String var2);

    @Message(id=12, value="Invalid action type %s")
    public IllegalStateException invalidActionType(DeploymentAction.Type var1);

    @Message(id=13, value="Preceding action was not a %s")
    public IllegalStateException invalidPrecedingAction(Object var1);

    @Message(id=14, value="%s is not a valid URI")
    public IllegalArgumentException invalidUri(@Cause Throwable var1, URL var2);

    @Message(id=15, value="Illegal %s value %d -- must be greater than %d")
    public IllegalArgumentException invalidValue(String var1, int var2, int var3);

    @Message(id=16, value="Illegal %s value %d -- must be greater than %d and less than %d")
    public IllegalArgumentException invalidValue(String var1, int var2, int var3, int var4);

    @Message(id=17, value="Screen real estate is expensive; displayUnits must be 5 characters or less")
    public RuntimeException maxDisplayUnitLength();

    @Message(id=18, value="No active request found for %d")
    public IOException noActiveRequest(int var1);

    @Message(id=19, value="No failure details provided")
    public String noFailureDetails();

    @Message(id=20, value="No %s is configured")
    public IllegalStateException notConfigured(String var1);

    @Message(id=21, value="%s is null")
    public IllegalArgumentException nullVar(String var1);

    @Message(id=22, value="%s is closed")
    public IllegalStateException objectIsClosed(String var1);

    @Message(id=23, value="Operation outcome is %s")
    public RuntimeException operationOutcome(String var1);

    @Message(id=24, value="%s operations are not allowed after content and deployment modifications")
    public IllegalStateException operationsNotAllowed(String var1);

    @Message(id=25, value="Rollback was cancelled")
    public RollbackCancelledException rollbackCancelled();

    @Message(id=26, value="Rollback was itself rolled back")
    public RollbackCancelledException rollbackRolledBack();

    @Message(id=27, value="Rollback timed out")
    public RollbackCancelledException rollbackTimedOut();

    @Message(id=28, value="Deployment with name %s already present in the server")
    public String serverDeploymentAlreadyExists(String var1);

    @Message(id=29, value="Unknown action type %s")
    public IllegalStateException unknownActionType(Object var1);

    @Message(id=30, value="Allocation stack trace:")
    public LeakDescription controllerClientNotClosed();

    @Message(id=31, value="No failure description as the operation was successful.")
    public IllegalArgumentException noFailureDescription();

    @Message(id=32, value="The operation name was not defined.")
    public IllegalArgumentException operationNameNotFound();

    @Message(id=33, value="The address must be of type ModelType.LIST.")
    public IllegalArgumentException invalidAddressType();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=34, value="Closing leaked controller client")
    public void leakedControllerClient(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=35, value="Cannot delete temp file %s, will be deleted on exit")
    public void cannotDeleteTempFile(String var1);

    @Message(id=36, value="Stream was closed")
    public IOException streamWasClosed();

    static;

    /*
     * Exception performing whole class analysis ignored.
     */
    public static class LeakDescription
    extends Throwable {
        private static final long serialVersionUID = -7193498784746897578L;

        public LeakDescription();

        public LeakDescription(String var1);

        @Override
        public String toString();
    }
}

