/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.indexes.spi.IndexManager;

public class WorkQueuePerIndexSplitter {
    private final HashMap<String, WorkPlan> queues = new HashMap();

    public List<LuceneWork> getIndexManagerQueue(IndexManager indexManager) {
        String indexName = indexManager.getIndexName();
        WorkPlan plan = this.queues.get(indexName);
        if (plan == null) {
            plan = new WorkPlan(indexManager);
            this.queues.put(indexName, plan);
        }
        return plan.queue;
    }

    public void commitOperations(IndexingMonitor monitor) {
        for (WorkPlan plan : this.queues.values()) {
            plan.indexManager.performOperations(plan.queue, monitor);
        }
    }

    private static class WorkPlan {
        private final IndexManager indexManager;
        private final LinkedList<LuceneWork> queue = new LinkedList();

        WorkPlan(IndexManager indexManager) {
            this.indexManager = indexManager;
        }
    }
}

