/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.metadata.type.archive.ArchiveMetadata;
import org.jboss.windup.metadata.type.archive.ZipMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecursiveZipMetaFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RecursiveZipMetaFactory.class);
    private static final int BUFFER = 2048;
    private File startLocation;
    private final String safeExtractKey;
    private Set<String> kae = new HashSet<String>();

    public RecursiveZipMetaFactory(File startLocation, Set<String> extensions) {
        UUID uuidKey = UUID.randomUUID();
        this.safeExtractKey = "_" + StringUtils.substring((String)StringUtils.remove((String)uuidKey.toString(), (String)"-"), (int)0, (int)6);
        this.startLocation = new File(startLocation.getAbsolutePath() + File.separator + "jboss_windup" + this.safeExtractKey);
        this.kae = extensions;
    }

    public void releaseTempFiles() {
        LOG.debug("Cleaning up: " + this.startLocation.getAbsolutePath());
        FileUtils.deleteQuietly((File)this.startLocation);
    }

    public ZipMetadata recursivelyExtract(ZipFile zip) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(zip.getName() + ": " + this.startLocation.getAbsolutePath());
        }
        ZipMetadata archive = this.generateArchive(null, new File(zip.getName()));
        this.recursivelyExtract(archive, zip, this.startLocation);
        return archive;
    }

    protected void recursivelyExtract(ZipMetadata parent, ZipFile zip, File outputDirectory) {
        String fileName = StringUtils.substringAfterLast((String)zip.getName(), (String)File.separator);
        File subOutputDir = new File(outputDirectory.getAbsolutePath() + File.separator + fileName);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory() || !this.archiveEndInEntryOfInterest(entry.getName())) continue;
            try {
                File extracted = this.unzipEntry(parent, entry, zip, subOutputDir);
                ZipFile zf = new ZipFile(extracted);
                ZipMetadata arch = this.generateArchive(parent, extracted);
                LOG.info("Prepared ZipMetadata: " + arch.getRelativePath());
                this.recursivelyExtract(arch, zf, new File(StringUtils.substringBeforeLast((String)zf.getName(), (String)File.separator)));
            }
            catch (FileNotFoundException e1) {
                LOG.warn("Skipping invalid zip entry: " + entry);
            }
            catch (IOException e1) {
                LOG.warn("Skipping invalid zip entry: " + entry);
            }
        }
        try {
            zip.close();
        }
        catch (IOException e1) {
            LOG.error("Exception closing zip.", (Throwable)e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File unzipEntry(ZipMetadata parent, ZipEntry entry, ZipFile zipfile, File archiveOutputDirectory) {
        block7: {
            BufferedOutputStream dest = null;
            BufferedInputStream is = null;
            String pathOutput = null;
            pathOutput = StringUtils.contains((String)entry.toString(), (String)"/") ? StringUtils.substringBeforeLast((String)entry.toString(), (String)"/") : File.separator;
            File entryPathOutput = new File(archiveOutputDirectory.getAbsolutePath() + this.safeExtractKey + File.separator + pathOutput);
            File entryOutput = new File(archiveOutputDirectory.getAbsolutePath() + this.safeExtractKey + File.separator + entry);
            if (!entryOutput.exists()) {
                File file;
                try {
                    int count;
                    FileUtils.forceMkdir((File)entryPathOutput);
                    is = new BufferedInputStream(zipfile.getInputStream(entry));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unzipping: " + entryOutput.getAbsolutePath());
                    }
                    byte[] data = new byte[2048];
                    FileOutputStream fos = new FileOutputStream(entryOutput);
                    dest = new BufferedOutputStream(fos, 2048);
                    while ((count = is.read(data, 0, 2048)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                    file = entryOutput;
                }
                catch (IOException e) {
                    try {
                        LOG.error("IOException: " + e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        IOUtils.closeQuietly(dest);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    IOUtils.closeQuietly(dest);
                    break block7;
                }
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)dest);
                return file;
            }
            LOG.warn("Entry: " + entry.toString() + " is a duplicate.  Returning the first entry.");
            return entryOutput;
        }
        return null;
    }

    private boolean archiveEndInEntryOfInterest(String entryName) {
        for (String extension : this.kae) {
            if (!StringUtils.endsWith((String)entryName, (String)extension)) continue;
            return true;
        }
        return false;
    }

    private ZipMetadata generateArchive(ZipMetadata parent, File entryOutput) {
        String relativePath = StringUtils.removeStart((String)entryOutput.getAbsolutePath(), (String)this.startLocation.getAbsolutePath().toString());
        if (LOG.isTraceEnabled()) {
            LOG.trace("RE Relative Path: " + relativePath);
            LOG.trace("SafeKey: " + this.safeExtractKey);
        }
        relativePath = StringUtils.replace((String)relativePath, (String)"\\", (String)"/");
        String archiveName = relativePath = StringUtils.contains((String)(relativePath = StringUtils.removeStart((String)relativePath, (String)"/")), (String)this.safeExtractKey) ? StringUtils.remove((String)relativePath, (String)this.safeExtractKey) : StringUtils.substringAfterLast((String)relativePath, (String)"/");
        if (StringUtils.contains((String)archiveName, (String)"/")) {
            archiveName = StringUtils.substringAfterLast((String)relativePath, (String)"/");
        }
        ZipMetadata archive = new ZipMetadata();
        archive.setName(archiveName);
        archive.setFilePointer(entryOutput);
        archive.setRelativePath(relativePath);
        if (parent != null) {
            parent.getNestedArchives().add(archive);
        }
        archive.setArchiveMeta((ArchiveMetadata)parent);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created archive: " + archive.toString());
        }
        return archive;
    }
}

