/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang.StringUtils;
import org.freecompany.redline.ChannelWrapper;
import org.freecompany.redline.ReadableChannelWrapper;
import org.freecompany.redline.header.AbstractHeader;
import org.freecompany.redline.header.Format;
import org.freecompany.redline.header.Header;
import org.freecompany.redline.header.Signature;
import org.freecompany.redline.payload.CpioHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPMToZipTransformer {
    private static Logger LOG = LoggerFactory.getLogger(RPMToZipTransformer.class);

    public static File convertRpmToZip(File file) throws Exception {
        CpioHeader header;
        LOG.info("File: " + file.getAbsolutePath());
        FileInputStream fis = new FileInputStream(file);
        ReadableChannelWrapper in = new ReadableChannelWrapper(Channels.newChannel(fis));
        GZIPInputStream uncompressed = new GZIPInputStream(fis);
        in = new ReadableChannelWrapper(Channels.newChannel(uncompressed));
        String rpmZipName = file.getName();
        rpmZipName = StringUtils.replace((String)rpmZipName, (String)".", (String)"-");
        rpmZipName = rpmZipName + ".zip";
        String rpmZipPath = FilenameUtils.getFullPath((String)file.getAbsolutePath());
        File rpmZipOutput = new File(rpmZipPath + File.separator + rpmZipName);
        LOG.info("Converting RPM: " + file.getName() + " to ZIP: " + rpmZipOutput.getName());
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(rpmZipOutput));
        String rpmName = file.getName();
        rpmName = StringUtils.replace((String)rpmName, (String)".", (String)"-");
        int total = 0;
        do {
            header = new CpioHeader();
            total = header.read((ReadableByteChannel)in, total);
            if (header.getFileSize() > 0) {
                BoundedInputStream bis = new BoundedInputStream((InputStream)uncompressed, (long)header.getFileSize());
                String relPath = FilenameUtils.separatorsToSystem((String)header.getName());
                relPath = StringUtils.removeStart((String)relPath, (String)".");
                relPath = StringUtils.removeStart((String)relPath, (String)"/");
                relPath = rpmName + File.separator + relPath;
                relPath = StringUtils.replace((String)relPath, (String)"\\", (String)"/");
                ZipEntry zipEntry = new ZipEntry(relPath);
                zos.putNextEntry(zipEntry);
                IOUtils.copy((InputStream)bis, (OutputStream)zos);
            } else {
                int skip = header.getFileSize();
                if (((InputStream)uncompressed).skip(skip) != (long)skip) {
                    throw new RuntimeException("Skip failed.");
                }
            }
            total += header.getFileSize();
        } while (!header.isLast());
        zos.flush();
        zos.close();
        return rpmZipOutput;
    }

    public static Format readFormat(ReadableChannelWrapper in) throws Exception {
        Format format = new Format();
        ChannelWrapper.Key lead = in.start();
        format.getLead().read((ReadableByteChannel)in);
        LOG.trace("Lead ended at '" + in.finish(lead) + "'.");
        ChannelWrapper.Key signature = in.start();
        int count = format.getSignature().read((ReadableByteChannel)in);
        int expected = ByteBuffer.wrap((byte[])format.getSignature().getEntry((AbstractHeader.Tag)Signature.SignatureTag.SIGNATURES).getValues(), 8, 4).getInt() / -16;
        LOG.trace("Signature ended at '" + in.finish(signature) + "' and contained '" + count + "' headers (expected '" + expected + "').");
        ChannelWrapper.Key header = in.start();
        count = format.getHeader().read((ReadableByteChannel)in);
        expected = ByteBuffer.wrap((byte[])format.getHeader().getEntry((AbstractHeader.Tag)Header.HeaderTag.HEADERIMMUTABLE).getValues(), 8, 4).getInt() / -16;
        LOG.trace("Header ended at '" + in.finish(header) + " and contained '" + count + "' headers (expected '" + expected + "').");
        return format;
    }
}

