/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.interrogator.impl;

import java.io.File;
import org.jboss.windup.interrogator.impl.ExtensionInterrogator;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.metadata.type.JspMetadata;
import org.jboss.windup.metadata.type.ZipEntryMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspInterrogator
extends ExtensionInterrogator<JspMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(JspInterrogator.class);

    @Override
    public JspMetadata fileEntryToMeta(FileMetadata entry) {
        File file = entry.getFilePointer();
        LOG.debug("Processing: " + file.getAbsolutePath());
        JspMetadata meta = new JspMetadata();
        meta.setArchiveMeta(entry.getArchiveMeta());
        meta.setFilePointer(file);
        return meta;
    }

    @Override
    public JspMetadata archiveEntryToMeta(ZipEntryMetadata archiveEntry) {
        File file = archiveEntry.getFilePointer();
        LOG.debug("Processing: " + file.getAbsolutePath());
        JspMetadata meta = new JspMetadata();
        meta.setArchiveMeta(archiveEntry.getArchiveMeta());
        meta.setFilePointer(file);
        return meta;
    }
}

