/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.xml.ejb;

import java.util.HashSet;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.decorator.MetaDecorator;
import org.jboss.windup.metadata.decoration.Line;
import org.jboss.windup.metadata.decoration.effort.Effort;
import org.jboss.windup.metadata.decoration.effort.StoryPointEffort;
import org.jboss.windup.metadata.decoration.hint.MarkdownHint;
import org.jboss.windup.metadata.type.XmlMetadata;
import org.jboss.windup.metadata.util.LocationAwareXmlReader;
import org.jboss.windup.util.XmlElementUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EJBValidatingDecorator
implements MetaDecorator<XmlMetadata>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(EJBValidatingDecorator.class);
    private static final XPathFactory factory = XPathFactory.newInstance();
    private static final String XPATH_EJB_RELATIONSHIP = "//*[local-name()='ejb-relation']/*[local-name()='ejb-relationship-role'][2]";
    private static final String XPATH_EJB_NAME_PROTOTYPE = "//*[local-name()='entity'][ejb-name='${entity-name}']";
    private XPath xpath;
    private XPathExpression ejbRelationshipExpression;

    @Override
    public void processMeta(XmlMetadata meta) {
        HashSet<String> ejbNames = new HashSet<String>();
        try {
            NodeList nodes;
            Document doc = meta.getParsedDocument();
            if (doc == null) {
                throw new NullPointerException();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing: " + this.ejbRelationshipExpression);
            }
            if ((nodes = (NodeList)this.ejbRelationshipExpression.evaluate(doc, XPathConstants.NODESET)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found results for: " + meta.getFilePointer().getAbsolutePath());
                }
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element relationshipRoleSource = XmlElementUtil.getChildByTagName((Element)nodes.item(i), "relationship-role-source");
                    Element ejbName = XmlElementUtil.getChildByTagName(relationshipRoleSource, "ejb-name");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found relationship: " + ejbName.getTextContent());
                    }
                    ejbNames.add(ejbName.getTextContent());
                }
            }
            for (String ejbName : ejbNames) {
                MarkdownHint simpleHint;
                Line result;
                String ejbLookup = StringUtils.replace((String)XPATH_EJB_NAME_PROTOTYPE, (String)"${entity-name}", (String)ejbName);
                Element ejbEntityNode = (Element)this.xpath.evaluate(ejbLookup, doc, XPathConstants.NODE);
                Integer lineNumber = LocationAwareXmlReader.getLineNumber((Node)ejbEntityNode);
                Element localTag = XmlElementUtil.getChildByTagName(ejbEntityNode, "local");
                Element localHomeTag = XmlElementUtil.getChildByTagName(ejbEntityNode, "local-home");
                if (LOG.isDebugEnabled()) {
                    LOG.info("XPath: " + ejbLookup);
                    LOG.debug("Line: " + lineNumber);
                    LOG.debug("Local tag null: " + (localTag == null));
                    LOG.debug("Local-home tag null: " + (localHomeTag == null));
                }
                if (localTag == null) {
                    result = new Line();
                    result.setDescription("Entity: " + ejbName + " does not expose required local interface.");
                    result.setLineNumber(lineNumber);
                    result.setPattern("//entity[ejb-name]/local");
                    result.setEffort((Effort)new StoryPointEffort(Integer.valueOf(1)));
                    simpleHint = new MarkdownHint();
                    simpleHint.setMarkdown("Create a local interface for the Entity bean to support Container Managed Relationship (CMR).");
                    result.getHints().add(simpleHint);
                    meta.getDecorations().add(result);
                }
                if (localHomeTag != null) continue;
                result = new Line();
                result.setDescription("Entity: " + ejbName + " does not expose required local-home interface.");
                result.setLineNumber(lineNumber);
                result.setPattern("//entity[ejb-name]/local-home");
                result.setEffort((Effort)new StoryPointEffort(Integer.valueOf(1)));
                simpleHint = new MarkdownHint();
                simpleHint.setMarkdown("Create a local-home interface for the Entity bean to support Container Managed Relationship (CMR).");
                result.getHints().add(simpleHint);
                meta.getDecorations().add(result);
            }
        }
        catch (Exception e) {
            LOG.error("Exception during XPath.", (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.xpath = factory.newXPath();
        this.ejbRelationshipExpression = this.xpath.compile(XPATH_EJB_RELATIONSHIP);
    }
}

