/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.xml;

import java.io.File;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.jboss.windup.decorator.MetaDecorator;
import org.jboss.windup.metadata.decoration.Link;
import org.jboss.windup.metadata.decoration.effort.Effort;
import org.jboss.windup.metadata.decoration.effort.UnknownEffort;
import org.jboss.windup.metadata.type.XmlMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class XSLTDecorator
implements MetaDecorator<XmlMetadata>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(XSLTDecorator.class);
    private String xsltLocation;
    private String outputExtension;
    private String outputDescription;
    private Transformer xsltTransformer;
    private Map<String, String> xsltParameters;
    private Effort effort = new UnknownEffort();

    public Effort getEffort() {
        return this.effort;
    }

    public void setXsltParameters(Map<String, String> xsltParameters) {
        this.xsltParameters = xsltParameters;
    }

    public void setEffort(Effort effort) {
        this.effort = effort;
    }

    public void setXsltLocation(String xsltLocation) {
        this.xsltLocation = xsltLocation;
    }

    public void setOutputDescription(String outputDescription) {
        this.outputDescription = outputDescription;
    }

    public void setOutputExtension(String outputExtension) {
        this.outputExtension = outputExtension;
    }

    @Override
    public void processMeta(XmlMetadata file) {
        String relativeDirectory = StringUtils.substringBeforeLast((String)file.getFilePointer().getAbsolutePath(), (String)File.separator);
        String fileName = StringUtils.substringAfterLast((String)file.getFilePointer().getAbsolutePath(), (String)File.separator);
        fileName = StringUtils.replace((String)fileName, (String)".", (String)"-");
        fileName = fileName + this.outputExtension;
        File relativeFile = new File(relativeDirectory + File.separator + fileName);
        DOMSource xmlSource = new DOMSource(file.getParsedDocument());
        StreamResult xmlResult = new StreamResult(relativeFile);
        try {
            this.xsltTransformer.transform(xmlSource, xmlResult);
            Link linkResult = new Link();
            linkResult.setDescription(this.outputDescription);
            linkResult.setLink(fileName);
            linkResult.setEffort(this.effort);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created link: " + ReflectionToStringBuilder.toString((Object)linkResult));
            }
            file.getDecorations().add(linkResult);
        }
        catch (TransformerException e) {
            LOG.error("Exception transforming XML.", (Throwable)e);
        }
    }

    public void afterPropertiesSet() {
        LOG.debug("Getting XSLT Location: " + this.xsltLocation);
        StreamSource xsltSource = new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.xsltLocation));
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setURIResolver(new URIResolver(){

                @Override
                public Source resolve(String href, String base) throws TransformerException {
                    if (StringUtils.contains((String)href, (String)"http://")) {
                        LOG.warn("Trying to fetch remote URL for XSLT.  This is not possible; for speed reasons: " + href + ": " + base);
                        return null;
                    }
                    return new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(href));
                }
            });
            this.xsltTransformer = tf.newTransformer(xsltSource);
            if (this.xsltParameters != null) {
                for (String key : this.xsltParameters.keySet()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Setting property: " + key + " -> " + this.xsltParameters.get(key));
                    }
                    this.xsltTransformer.setParameter(key, this.xsltParameters.get(key));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created XSLT successfully: " + this.xsltLocation);
            }
        }
        catch (Exception e) {
            LOG.error("Exception creating XSLT: " + this.xsltLocation, (Throwable)e);
        }
    }
}

