/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.java.decompiler;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import net.sf.jadretro.Main;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.lang.SystemUtils;
import org.jboss.windup.decorator.java.decompiler.DecompilerAdapter;
import org.jboss.windup.util.FatalWindupException;
import org.jboss.windup.util.LogController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadretroDecompilerAdapter
implements DecompilerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(JadretroDecompilerAdapter.class);
    private final String APP_NAME;

    public JadretroDecompilerAdapter() {
        LogController.LoggingAdapter.tieSystemOutAndErrToLog();
        this.APP_NAME = SystemUtils.IS_OS_WINDOWS ? "jad.exe" : "jad";
    }

    @Override
    public void decompile(String className, String classLocation, String sourceOutputLocation) {
        LOG.info("Decompiling: " + className);
        Main.main((String[])new String[]{classLocation});
        this.executeJad(new File(classLocation), new File(sourceOutputLocation));
        LOG.info("... Complete");
    }

    @Override
    public void decompile(String className, File classLocation, File sourceOutputLocation) {
        LOG.info("Decompiling: " + className + " to: " + sourceOutputLocation.getAbsolutePath());
        Main.main((String[])new String[]{classLocation.getAbsolutePath()});
        this.executeJad(classLocation, sourceOutputLocation);
        LOG.info("... Complete");
    }

    private void executeJad(File classLocation, File sourceOutputLocation) {
        try {
            CommandLine cmdLine = new CommandLine(this.APP_NAME);
            cmdLine.addArgument("-d");
            cmdLine.addArgument("${outputLocation}");
            cmdLine.addArgument("-f");
            cmdLine.addArgument("-o");
            cmdLine.addArgument("-s");
            cmdLine.addArgument("java");
            cmdLine.addArgument("${classLocation}");
            HashMap<String, File> argMap = new HashMap<String, File>();
            argMap.put("outputLocation", sourceOutputLocation);
            argMap.put("classLocation", classLocation);
            cmdLine.setSubstitutionMap(argMap);
            DefaultExecutor executor = new DefaultExecutor();
            executor.setExitValue(0);
            ExecuteWatchdog watchdog = new ExecuteWatchdog(60000L);
            executor.setWatchdog(watchdog);
            int exitValue = executor.execute(cmdLine);
            LOG.debug("Decompiler exited with exit code: " + exitValue);
            if (!sourceOutputLocation.exists()) {
                LOG.error("Expected decompiled source: " + sourceOutputLocation.getAbsolutePath() + "; did not find file.  This likey means that the decompiler did not successfully decompile the class.");
            } else {
                LOG.debug("Decompiled to: " + sourceOutputLocation.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new FatalWindupException("Error running " + this.APP_NAME + " decompiler.  Validate that " + this.APP_NAME + " is on your PATH.", e);
        }
    }
}

