/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.jboss.windup.metadata.decoration.JavaLine;
import org.jboss.windup.metadata.decoration.SourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaASTVariableResolvingVisitor
extends ASTVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(JavaASTVariableResolvingVisitor.class);
    private final Collection<AbstractDecoration> results;
    private final CompilationUnit cu;
    private final Set<String> classBlacklists;
    private final Map<String, String> classNameToFullyQualified = new HashMap<String, String>();
    Set<String> names = new HashSet<String>();
    Map<String, String> nameInstance = new HashMap<String, String>();

    public JavaASTVariableResolvingVisitor(CompilationUnit cu, Collection<AbstractDecoration> results, String qualifiedClassName, Set<String> knownDependencies, Set<String> blacklists) {
        this.results = results;
        this.cu = cu;
        this.classBlacklists = blacklists;
        for (String dependency : knownDependencies) {
            this.classNameToFullyQualified.put(StringUtils.substringAfterLast((String)dependency, (String)"."), dependency);
        }
        this.names.add("this");
        this.nameInstance.put("this", qualifiedClassName);
        this.classNameToFullyQualified.put(StringUtils.substringAfterLast((String)qualifiedClassName, (String)"."), qualifiedClassName);
    }

    public Collection<AbstractDecoration> getResults() {
        return this.results;
    }

    private void processInterest(String interest, int lineStart, String decoratorPrefix, SourceType sourceType) {
        int sourcePosition = lineStart;
        String sourceString = interest;
        if (!StringUtils.contains((String)sourceString, (String)".") && this.classNameToFullyQualified.containsKey(sourceString)) {
            sourceString = this.classNameToFullyQualified.get(sourceString);
        }
        if (this.lineContainsClassBlacklist(sourceString)) {
            JavaLine dr = new JavaLine();
            dr.setDescription(decoratorPrefix + " '" + sourceString + "' at line " + sourcePosition);
            dr.setLineNumber(Integer.valueOf(sourcePosition));
            dr.setSourceType(sourceType);
            dr.setPattern(sourceString);
            this.results.add((AbstractDecoration)dr);
        }
    }

    private void processType(Type type, String decoratorPrefix, SourceType sourceType) {
        if (type == null) {
            return;
        }
        int sourcePosition = this.cu.getLineNumber(type.getStartPosition());
        String sourceString = type.toString();
        if (!StringUtils.contains((String)sourceString, (String)".") && this.classNameToFullyQualified.containsKey(sourceString)) {
            sourceString = this.classNameToFullyQualified.get(sourceString);
        }
        if (this.lineContainsClassBlacklist(sourceString)) {
            JavaLine dr = new JavaLine();
            dr.setDescription(decoratorPrefix + " '" + sourceString + "' at line " + sourcePosition);
            dr.setLineNumber(Integer.valueOf(sourcePosition));
            dr.setSourceType(sourceType);
            dr.setPattern(sourceString);
            this.results.add((AbstractDecoration)dr);
        }
    }

    private void processName(Name name, String decoratorPrefix, int position) {
        if (name == null) {
            return;
        }
        int sourcePosition = position;
        String sourceString = name.toString();
        if (!StringUtils.contains((String)sourceString, (String)".") && this.classNameToFullyQualified.containsKey(sourceString)) {
            sourceString = this.classNameToFullyQualified.get(sourceString);
        }
        if (this.lineContainsClassBlacklist(sourceString)) {
            JavaLine dr = new JavaLine();
            dr.setDescription(decoratorPrefix + " '" + sourceString + "' at line " + sourcePosition);
            dr.setLineNumber(Integer.valueOf(sourcePosition));
            dr.setSourceType(SourceType.TYPE);
            dr.setPattern(sourceString);
            this.results.add((AbstractDecoration)dr);
        }
    }

    public boolean visit(TypeDeclarationStatement node) {
        return super.visit(node);
    }

    public boolean visit(MethodDeclaration node) {
        List throwsTypes;
        List parameters;
        Type returnType = node.getReturnType2();
        if (returnType != null) {
            this.processType(returnType, "Return type", SourceType.TYPE);
        }
        if ((parameters = node.parameters()) != null) {
            for (SingleVariableDeclaration type : parameters) {
                String typeName = type.getType().toString();
                if (this.classNameToFullyQualified.containsKey(typeName)) {
                    typeName = this.classNameToFullyQualified.get(typeName);
                }
                this.names.add(type.getName().toString());
                this.nameInstance.put(type.getName().toString(), typeName);
                this.processType(type.getType(), "Method parameter", SourceType.TYPE);
            }
        }
        if ((throwsTypes = node.thrownExceptions()) != null) {
            for (Name name : throwsTypes) {
                this.processName(name, "Throws", node.getStartPosition());
            }
        }
        return true;
    }

    public boolean visit(ThrowStatement node) {
        if (node.getExpression() instanceof ClassInstanceCreation) {
            ClassInstanceCreation cic = (ClassInstanceCreation)node.getExpression();
            this.processType(cic.getType(), "Throwing", SourceType.TYPE);
        }
        return true;
    }

    public boolean visit(CatchClause node) {
        Type catchType = node.getException().getType();
        this.processType(catchType, "Catching", SourceType.TYPE);
        return true;
    }

    public boolean visit(ReturnStatement node) {
        if (node.getExpression() instanceof ClassInstanceCreation) {
            ClassInstanceCreation cic = (ClassInstanceCreation)node.getExpression();
            this.processType(cic.getType(), "Declaring", SourceType.TYPE);
        }
        return super.visit(node);
    }

    public boolean visit(TypeDeclaration node) {
        Type superClasses = node.getSuperclassType();
        List superInterfaces = node.superInterfaceTypes();
        this.processType(superClasses, "Extending class", SourceType.INHERITANCE);
        if (superInterfaces != null) {
            for (Type inter : superInterfaces) {
                this.processType(inter, "Implementing interface", SourceType.INHERITANCE);
            }
        }
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        String nodeType = node.getType().toString();
        if (this.classNameToFullyQualified.containsKey(nodeType)) {
            nodeType = this.classNameToFullyQualified.get(nodeType);
        }
        List<String> resolvedParams = this.methodParameterGuesser(node.arguments());
        String resolvedConstructorCall = nodeType + "(";
        int j = resolvedParams.size();
        for (int i = 0; i < j; ++i) {
            resolvedConstructorCall = resolvedConstructorCall + resolvedParams.get(i);
            if (i >= j - 1) continue;
            resolvedConstructorCall = resolvedConstructorCall + ", ";
        }
        resolvedConstructorCall = resolvedConstructorCall + ")";
        LOG.trace("Resolved Constructor: " + resolvedConstructorCall);
        this.processInterest(resolvedConstructorCall, this.cu.getLineNumber(node.getStartPosition()), "Constructing type", SourceType.CONSTRUCT);
        return super.visit(node);
    }

    public boolean visit(FieldDeclaration node) {
        for (int i = 0; i < node.fragments().size(); ++i) {
            String nodeType = node.getType().toString();
            if (!StringUtils.contains((String)nodeType, (String)".") && this.classNameToFullyQualified.containsKey(nodeType)) {
                nodeType = this.classNameToFullyQualified.get(nodeType);
            }
            VariableDeclarationFragment frag = (VariableDeclarationFragment)node.fragments().get(i);
            frag.resolveBinding();
            this.names.add(frag.getName().getIdentifier());
            this.nameInstance.put(frag.getName().toString(), nodeType.toString());
            this.processType(node.getType(), "Declaring type", SourceType.TYPE);
        }
        return true;
    }

    public boolean visit(MarkerAnnotation node) {
        this.processName(node.getTypeName(), "Annotation", this.cu.getLineNumber(node.getStartPosition()));
        return super.visit(node);
    }

    public boolean visit(NormalAnnotation node) {
        this.processName(node.getTypeName(), "Annotation", this.cu.getLineNumber(node.getStartPosition()));
        return super.visit(node);
    }

    public boolean visit(SingleMemberAnnotation node) {
        this.processName(node.getTypeName(), "Annotation", this.cu.getLineNumber(node.getStartPosition()));
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationStatement node) {
        for (int i = 0; i < node.fragments().size(); ++i) {
            String nodeType = node.getType().toString();
            if (!StringUtils.contains((String)nodeType, (String)".") && this.classNameToFullyQualified.containsKey(nodeType)) {
                nodeType = this.classNameToFullyQualified.get(nodeType);
            }
            VariableDeclarationFragment frag = (VariableDeclarationFragment)node.fragments().get(i);
            this.names.add(frag.getName().getIdentifier());
            this.nameInstance.put(frag.getName().toString(), nodeType.toString());
            this.processType(node.getType(), "Declaring type", SourceType.TYPE);
        }
        return true;
    }

    public boolean visit(ImportDeclaration node) {
        String name = node.getName().toString();
        if (!node.isOnDemand()) {
            String clzName = StringUtils.substringAfterLast((String)name, (String)".");
            this.classNameToFullyQualified.put(clzName, name);
            this.processInterest(node.getName().toString(), this.cu.getLineNumber(node.getStartPosition()), "Import of", SourceType.IMPORT);
        } else if (this.lineContainsPackageBlacklist(name)) {
            for (String knownClz : this.classNameToFullyQualified.values()) {
                if (!StringUtils.startsWith((String)knownClz, (String)name)) continue;
                this.processInterest(knownClz, this.cu.getLineNumber(node.getStartPosition()), "Leads to import of", SourceType.IMPORT);
            }
        }
        return true;
    }

    public boolean visit(MethodInvocation node) {
        if (!StringUtils.contains((String)node.toString(), (String)".")) {
            return true;
        }
        String nodeName = StringUtils.removeStart((String)node.toString(), (String)"this.");
        List arguements = node.arguments();
        List<String> resolvedParams = this.methodParameterGuesser(arguements);
        String objRef = StringUtils.substringBefore((String)nodeName, (String)("." + node.getName().toString()));
        if (this.nameInstance.containsKey(objRef)) {
            objRef = this.nameInstance.get(objRef);
        }
        if (this.classNameToFullyQualified.containsKey(objRef)) {
            objRef = this.classNameToFullyQualified.get(objRef);
        }
        String resolvedMethodCall = objRef + "." + node.getName().toString() + "(";
        int j = resolvedParams.size();
        for (int i = 0; i < j; ++i) {
            resolvedMethodCall = resolvedMethodCall + resolvedParams.get(i);
            if (i >= j - 1) continue;
            resolvedMethodCall = resolvedMethodCall + ", ";
        }
        resolvedMethodCall = resolvedMethodCall + ")";
        LOG.trace("Resolved Method call: " + resolvedMethodCall);
        this.processInterest(resolvedMethodCall, this.cu.getLineNumber(node.getStartPosition()), "Usage of", SourceType.METHOD);
        return true;
    }

    private List<String> methodParameterGuesser(List arguements) {
        ArrayList<String> resolvedParams = new ArrayList<String>(arguements.size());
        for (Object o : arguements) {
            if (o instanceof SimpleName) {
                String name = this.nameInstance.get(o.toString());
                if (name != null) {
                    resolvedParams.add(name);
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            if (o instanceof StringLiteral) {
                resolvedParams.add("java.lang.String");
                continue;
            }
            if (o instanceof FieldAccess) {
                String field = ((FieldAccess)o).getName().toString();
                if (this.names.contains(field)) {
                    resolvedParams.add(this.nameInstance.get(field));
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            if (o instanceof CastExpression) {
                String type = ((CastExpression)o).getType().toString();
                type = this.qualifyType(type);
                resolvedParams.add(type);
                continue;
            }
            if (o instanceof MethodInvocation) {
                String on = ((MethodInvocation)o).getName().toString();
                if (StringUtils.equals((String)on, (String)"toString")) {
                    if (((MethodInvocation)o).arguments().size() != 0) continue;
                    resolvedParams.add("java.lang.String");
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            if (o instanceof NumberLiteral) {
                if (StringUtils.endsWith((String)o.toString(), (String)"L")) {
                    resolvedParams.add("long");
                    continue;
                }
                if (StringUtils.endsWith((String)o.toString(), (String)"f")) {
                    resolvedParams.add("float");
                    continue;
                }
                if (StringUtils.endsWith((String)o.toString(), (String)"d")) {
                    resolvedParams.add("double");
                    continue;
                }
                resolvedParams.add("int");
                continue;
            }
            if (o instanceof BooleanLiteral) {
                resolvedParams.add("boolean");
                continue;
            }
            if (o instanceof ClassInstanceCreation) {
                String nodeType = ((ClassInstanceCreation)o).getType().toString();
                if (this.classNameToFullyQualified.containsKey(nodeType)) {
                    nodeType = this.classNameToFullyQualified.get(nodeType.toString());
                }
                resolvedParams.add(nodeType);
                continue;
            }
            if (o instanceof CharacterLiteral) {
                resolvedParams.add("char");
                continue;
            }
            if (o instanceof InfixExpression) {
                String expression = o.toString();
                if (StringUtils.contains((String)expression, (String)"\"")) {
                    resolvedParams.add("java.lang.String");
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            LOG.debug("Unable to determine type: " + o.getClass() + ReflectionToStringBuilder.toString(o));
            resolvedParams.add("Undefined");
        }
        return resolvedParams;
    }

    private boolean lineContainsPackageBlacklist(String line) {
        for (String black : this.classBlacklists) {
            if (!StringUtils.startsWith((String)line, (String)(black = StringUtils.substringBeforeLast((String)black, (String)".")))) continue;
            return true;
        }
        return false;
    }

    private boolean lineContainsClassBlacklist(String line) {
        for (String black : this.classBlacklists) {
            if (!StringUtils.startsWith((String)line, (String)black)) continue;
            return true;
        }
        return false;
    }

    private String qualifyType(String objRef) {
        if (this.nameInstance.containsKey(objRef = StringUtils.removeEnd((String)objRef, (String)"[]"))) {
            objRef = this.nameInstance.get(objRef);
        }
        if (this.classNameToFullyQualified.containsKey(objRef)) {
            objRef = this.classNameToFullyQualified.get(objRef);
        }
        return objRef;
    }
}

