/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.archive;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.decorator.MetaDecorator;
import org.jboss.windup.interrogator.util.KnownArchiveProfiler;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.jboss.windup.metadata.decoration.archetype.version.PomVersion;
import org.jboss.windup.metadata.type.XmlMetadata;
import org.jboss.windup.metadata.type.archive.ZipMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.w3c.dom.Document;

public class PomVersionDecorator
implements MetaDecorator<XmlMetadata>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(PomVersionDecorator.class);
    private static final XPathFactory factory = XPathFactory.newInstance();
    private static final String GROUP_ID = "/*[local-name()='project']/*[local-name()='groupId']";
    private static final String ARTIFACT_ID = "/*[local-name()='project']/*[local-name()='artifactId']";
    private static final String VERSION = "/*[local-name()='project']/*[local-name()='version']";
    private static final String NAME = "/*[local-name()='project']/*[local-name()='name']";
    private static final String PARENT_GROUP_ID = "/*[local-name()='project']/*[local-name()='parent']/*[local-name()='groupId']";
    private static final String PARENT_VERSION = "/*[local-name()='project']/*[local-name()='parent']/*[local-name()='version']";
    protected XPathExpression groupIdXPath;
    protected XPathExpression artifactIdXPath;
    protected XPathExpression versionXPath;
    protected XPathExpression nameXPath;
    protected XPathExpression parentGroupIdXPath;
    protected XPathExpression parentVersionXPath;
    protected KnownArchiveProfiler knownArchiveProfiler;

    public void setKnownArchiveProfiler(KnownArchiveProfiler knownArchiveProfiler) {
        this.knownArchiveProfiler = knownArchiveProfiler;
    }

    @Override
    public void processMeta(XmlMetadata file) {
        if (!this.isActive(file)) {
            return;
        }
        Document doc = file.getParsedDocument();
        try {
            String artifactId;
            String version;
            String groupId = this.extractStringValue(this.groupIdXPath, doc);
            if (StringUtils.isBlank((String)groupId) || StringUtils.startsWith((String)groupId, (String)"${")) {
                LOG.debug("GroupId not found for file: " + file.getFilePointer().getAbsolutePath() + "; trying parent groupId...");
                groupId = this.extractStringValue(this.parentGroupIdXPath, doc);
                if (StringUtils.isBlank((String)groupId)) {
                    LOG.debug("Parent groupId not found for file: " + file.getFilePointer().getAbsolutePath() + "; skipping.");
                    return;
                }
            }
            if (StringUtils.isBlank((String)(version = this.extractStringValue(this.versionXPath, doc))) || StringUtils.startsWith((String)version, (String)"${")) {
                LOG.debug("Version not found for file: " + file.getFilePointer().getAbsolutePath() + "; trying parent version...");
                version = this.extractStringValue(this.parentVersionXPath, doc);
                if (StringUtils.isBlank((String)version)) {
                    LOG.debug("Parent version not found for file: " + file.getFilePointer().getAbsolutePath() + "; skipping.");
                    return;
                }
            }
            if (StringUtils.isBlank((String)(artifactId = this.extractStringValue(this.artifactIdXPath, doc)))) {
                LOG.debug("ArtifactId not found for file: " + file.getFilePointer().getAbsolutePath());
                return;
            }
            String name = this.extractStringValue(this.nameXPath, doc);
            this.createVersionResult(file, groupId, artifactId, version, name);
        }
        catch (XPathExpressionException e) {
            LOG.error("Exception running xpath expression.", (Throwable)e);
        }
    }

    protected String extractStringValue(XPathExpression expression, Document doc) throws XPathExpressionException {
        return (String)expression.evaluate(doc, XPathConstants.STRING);
    }

    protected boolean isActive(XmlMetadata file) {
        for (AbstractDecoration dr : file.getArchiveMeta().getDecorations()) {
            if (!(dr instanceof PomVersion)) continue;
            LOG.debug("Already has version result: " + dr.toString());
            return false;
        }
        return true;
    }

    protected void createVersionResult(XmlMetadata file, String groupId, String artifactId, String versionId, String name) {
        PomVersion vr = new PomVersion();
        if (StringUtils.isBlank((String)name)) {
            name = artifactId;
        }
        vr.setName(name);
        vr.setVersion(versionId);
        vr.setArchetypeId(artifactId);
        vr.setGroupId(groupId);
        file.getArchiveMeta().getDecorations().add(vr);
        if (file.getArchiveMeta() instanceof ZipMetadata) {
            ZipMetadata zip = (ZipMetadata)file.getArchiveMeta();
            this.knownArchiveProfiler.isKnownVendor(zip, groupId);
        }
    }

    public void afterPropertiesSet() throws Exception {
        XPath xpath = factory.newXPath();
        this.groupIdXPath = xpath.compile(GROUP_ID);
        this.artifactIdXPath = xpath.compile(ARTIFACT_ID);
        this.versionXPath = xpath.compile(VERSION);
        this.nameXPath = xpath.compile(NAME);
        this.parentGroupIdXPath = xpath.compile(PARENT_GROUP_ID);
        this.parentVersionXPath = xpath.compile(PARENT_VERSION);
    }
}

