/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator;

import java.util.List;
import org.jboss.windup.decorator.MetaDecorator;
import org.jboss.windup.hint.MatchingProcessor;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.jboss.windup.metadata.type.FileMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationLevelDecorator
implements MetaDecorator<FileMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationLevelDecorator.class);
    protected List<MatchingProcessor> matchingProcessors;
    protected AbstractDecoration.NotificationLevel notificationLevel;

    public void setNotificationLevel(AbstractDecoration.NotificationLevel notificationLevel) {
        this.notificationLevel = notificationLevel;
    }

    public void setMatchingProcessors(List<MatchingProcessor> matchingProcessors) {
        this.matchingProcessors = matchingProcessors;
    }

    @Override
    public void processMeta(FileMetadata file) {
        for (AbstractDecoration dr : file.getDecorations()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Applying notification to: " + this.matchingProcessors.size() + " for decoration: " + dr.getPattern());
            }
            for (MatchingProcessor hp : this.matchingProcessors) {
                if (!hp.process(dr)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Matched.  Setting Notification: " + this.notificationLevel);
                }
                dr.setLevel(this.notificationLevel);
            }
        }
    }
}

