/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator;

import java.util.List;
import org.jboss.windup.decorator.MetaDecorator;
import org.jboss.windup.metadata.decoration.effort.Effort;
import org.jboss.windup.metadata.decoration.effort.UnknownEffort;
import org.jboss.windup.metadata.type.ResourceMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChainingDecorator<T extends ResourceMetadata>
implements MetaDecorator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ChainingDecorator.class);
    protected List<MetaDecorator<T>> decorators;
    protected Effort effort = new UnknownEffort();

    public void setEffort(Effort effort) {
        this.effort = effort;
    }

    public void setDecorators(List<MetaDecorator<T>> decorators) {
        this.decorators = decorators;
    }

    public void addDecorators(List<MetaDecorator<T>> decorators) {
        this.decorators.addAll(decorators);
    }

    protected void chainDecorators(T meta) {
        if (this.decorators != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Decorators not null.  Running chained decorators: " + this.decorators.size());
            }
            for (MetaDecorator<T> decorator : this.decorators) {
                decorator.processMeta(meta);
            }
        }
    }
}

