/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.spring.namespace.java;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.util.XmlElementUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SpringNamespaceHandlerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SpringNamespaceHandlerUtil.class);

    public static void parseNamespaceMap(BeanDefinitionBuilder builder, Element element) {
        List<Element> elements = XmlElementUtil.getChildrenByTagName(element, "namespace");
        if (elements == null) {
            return;
        }
        ManagedMap namespaceMap = new ManagedMap(elements.size());
        for (Element bean : elements) {
            String prefix = bean.getAttribute("prefix");
            String namespace = bean.getAttribute("uri");
            namespaceMap.put((Object)prefix, (Object)namespace);
        }
        LOG.debug("Adding namespaces: " + namespaceMap.size());
        builder.addPropertyValue("namespaces", (Object)namespaceMap);
    }

    public static BeanDefinition resolveBeanDefinition(BeanDefinition beanDef, Element element, ParserContext context) {
        BeanDefinitionParserDelegate delegate = context.getDelegate();
        String namespace = element.getNamespaceURI();
        if (StringUtils.equals((String)namespace, (String)"http://www.springframework.org/schema/beans")) {
            BeanDefinitionHolder holder = delegate.parseBeanDefinitionElement(element, beanDef);
            return holder.getBeanDefinition();
        }
        NamespaceHandler namespaceHandler = delegate.getReaderContext().getNamespaceHandlerResolver().resolve(namespace);
        if (namespaceHandler == null) {
            throw new FatalBeanException("Unable to find parser for bean with namespace: " + namespace);
        }
        return namespaceHandler.parse(element, new ParserContext(delegate.getReaderContext(), delegate, beanDef));
    }

    public static void setNestedList(BeanDefinitionBuilder beanBuilder, Element bean, String nestedTagName, ParserContext context) {
        AbstractBeanDefinition beanDef = beanBuilder.getRawBeanDefinition();
        Element test = XmlElementUtil.getChildByTagName(bean, nestedTagName);
        if (test != null && test.hasAttribute("ref")) {
            beanBuilder.addPropertyReference(nestedTagName, test.getAttribute("ref"));
            return;
        }
        Element nestElement = XmlElementUtil.getChildByTagName(bean, nestedTagName);
        if (nestElement != null) {
            ManagedList<BeanDefinition> nested = SpringNamespaceHandlerUtil.parseManagedList((BeanDefinition)beanDef, XmlElementUtil.getChildElements(nestElement), context);
            beanBuilder.addPropertyValue(nestedTagName, nested);
        }
    }

    public static void setNestedMap(BeanDefinitionBuilder beanBuilder, Element bean, String nestedTagName, ParserContext context) {
        AbstractBeanDefinition beanDef = beanBuilder.getRawBeanDefinition();
        Element nestElement = XmlElementUtil.getChildByTagName(bean, nestedTagName);
        if (nestElement != null) {
            // empty if block
        }
    }

    public static ManagedList<BeanDefinition> parseManagedList(BeanDefinition beanDef, List<Element> elements, ParserContext context) {
        if (elements == null) {
            return null;
        }
        ManagedList beanDefs = new ManagedList(elements.size());
        for (Element bean : elements) {
            BeanDefinition def = SpringNamespaceHandlerUtil.resolveBeanDefinition(beanDef, bean, context);
            beanDefs.add((Object)def);
        }
        return beanDefs;
    }
}

