/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.spring.namespace.interrogator;

import java.util.List;
import org.jboss.windup.config.spring.namespace.java.SpringNamespaceHandlerUtil;
import org.jboss.windup.util.XmlElementUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class InterrogatorExtensionBeanParser
extends AbstractBeanDefinitionParser {
    private static final Logger LOG = LoggerFactory.getLogger(InterrogatorExtensionBeanParser.class);

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanBuilder = BeanDefinitionBuilder.rootBeanDefinition(MethodInvokingFactoryBean.class);
        InterrogatorTypeEnum interrogatorTarget = InterrogatorTypeEnum.valueOf(element.getAttribute("type"));
        String targetObject = interrogatorTarget.getBeanName();
        LOG.debug("Resolved target extension: " + targetObject);
        beanBuilder.addPropertyReference("targetObject", targetObject);
        beanBuilder.addPropertyValue("targetMethod", (Object)"addDecorators");
        this.parseDecoratorExtensions(beanBuilder, element, parserContext);
        return beanBuilder.getBeanDefinition();
    }

    private void parseDecoratorExtensions(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
        AbstractBeanDefinition beanDef = builder.getRawBeanDefinition();
        List<Element> elements = XmlElementUtil.getChildElements(element);
        if (elements == null) {
            return;
        }
        ManagedList<BeanDefinition> decorations = SpringNamespaceHandlerUtil.parseManagedList((BeanDefinition)beanDef, elements, parserContext);
        LOG.debug("Adding decorators: " + decorations.size());
        builder.addPropertyValue("arguments", decorations);
    }

    private static enum InterrogatorTypeEnum {
        XML("xmlPipeline"),
        JAVA("javaPipeline"),
        JSP("jspPipeline"),
        ARCHIVE("archivePipeline");

        private final String beanName;

        private InterrogatorTypeEnum(String beanName) {
            this.beanName = beanName;
        }

        public String getBeanName() {
            return this.beanName;
        }
    }
}

