/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jboss.windup.WindupEnvironment;
import org.jboss.windup.interrogator.DirectoryInterrogationEngine;
import org.jboss.windup.interrogator.FileInterrogationEngine;
import org.jboss.windup.interrogator.ZipInterrogationEngine;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.metadata.type.archive.ArchiveMetadata;
import org.jboss.windup.metadata.type.archive.DirectoryMetadata;
import org.jboss.windup.metadata.type.archive.ZipMetadata;
import org.jboss.windup.util.LogController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class WindupEngine {
    private static final Logger LOG = LoggerFactory.getLogger(WindupEngine.class);
    private ApplicationContext context;
    private List<String> supportedExtensions;
    private ZipInterrogationEngine interrogationEngine;
    private DirectoryInterrogationEngine directoryInterrogationEngine;
    private FileInterrogationEngine fileInterrogationEngine;
    private WindupEnvironment settings;

    public WindupEngine(WindupEnvironment settings) {
        this.setupEnvironment(settings);
        this.settings = settings;
        LinkedList<String> springContexts = new LinkedList<String>();
        springContexts.add("/jboss-windup-context.xml");
        this.context = new ClassPathXmlApplicationContext(springContexts.toArray(new String[springContexts.size()]));
        this.interrogationEngine = (ZipInterrogationEngine)this.context.getBean("archive-interrogation-engine");
        this.directoryInterrogationEngine = (DirectoryInterrogationEngine)this.context.getBean("directory-interrogation-engine");
        this.fileInterrogationEngine = (FileInterrogationEngine)this.context.getBean("file-interrogation-engine");
        this.supportedExtensions = new ArrayList<String>((Collection)this.context.getBean("zipExtensions"));
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    private void setupEnvironment(WindupEnvironment settings) {
        if (settings.getIncludeJavaPackageSignature() != null) {
            String javaPkgSigs = StringUtils.join(settings.getIncludeJavaPackageSignature(), (String)":");
            System.setProperty("package.signature", javaPkgSigs);
        } else {
            LOG.warn("WARNING: Consider specifying javaPkgs.  Otherwise, the Java code will not be inspected.");
        }
        if (settings.getExcludeJavaPackageSignature() != null) {
            String excSigString = StringUtils.join(settings.getExcludeJavaPackageSignature(), (String)":");
            System.setProperty("exclude.signature", excSigString);
        }
        if (StringUtils.isNotBlank((String)settings.getTargetPlatform())) {
            System.setProperty("target.platform", settings.getTargetPlatform());
        }
        if (settings.isFetchRemote()) {
            System.setProperty("fetch.remote", String.valueOf(settings.isFetchRemote()));
        } else {
            LOG.warn("INFO: Will not try and fetch remote versions for unknown JARs.  Consider using: '-fetchRemote true' command line for more detailed reporting.  Requires internet connection.");
            System.setProperty("fetch.remote", "false");
        }
    }

    public FileMetadata processFile(File file) throws IOException {
        Validate.notNull((Object)file, (String)"File is required, but provided as null.");
        if (!this.settings.isSource()) {
            throw new RuntimeException("Windup Engine must be set to source mode to process single files.");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("file does not exist: " + file);
        }
        if (!file.isFile()) {
            throw new FileNotFoundException("given file path does not reference a file: " + file.getAbsolutePath());
        }
        return this.fileInterrogationEngine.process(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveMetadata processSourceDirectory(File dirPath, File outputPath) throws IOException {
        Validate.notNull((Object)dirPath, (String)"Directory input path must be provided.");
        Validate.notNull((Object)dirPath.isDirectory(), (String)"Input must be a directory.");
        Validate.notNull((Object)outputPath, (String)"Directory output path must be provided.");
        File logFile = null;
        if (StringUtils.isNotBlank((String)this.settings.getLogLevel())) {
            LogController.setLogLevel(this.settings.getLogLevel());
        }
        try {
            if (this.settings.isCaptureLog()) {
                logFile = new File(outputPath.getAbsolutePath() + File.separator + "windup.log");
                LogController.addFileAppender(logFile);
            }
            DirectoryMetadata directoryMetadata = this.directoryInterrogationEngine.process(outputPath, dirPath);
            return directoryMetadata;
        }
        finally {
            if (logFile != null && logFile.exists()) {
                LogController.removeFileAppender(logFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveMetadata processArchive(File archivePath, File outputPath) throws IOException {
        Validate.notNull((Object)archivePath, (String)"Directory archivePath path must be provided.");
        Validate.notNull((Object)outputPath, (String)"Directory outputPath must be provided.");
        if (!archivePath.exists()) {
            throw new FileNotFoundException("Archive to process not found: " + archivePath.getPath());
        }
        File logFile = null;
        if (!outputPath.exists()) {
            FileUtils.forceMkdir((File)outputPath);
        }
        if (StringUtils.isNotBlank((String)this.settings.getLogLevel())) {
            LogController.setLogLevel(this.settings.getLogLevel());
        }
        try {
            if (this.settings.isCaptureLog()) {
                logFile = new File(outputPath.getAbsolutePath() + File.separator + "windup.log");
                LogController.addFileAppender(logFile);
            }
            ZipMetadata zipMetadata = this.interrogationEngine.process(outputPath, archivePath);
            return zipMetadata;
        }
        finally {
            if (logFile != null && logFile.exists()) {
                LogController.removeFileAppender(logFile);
            }
        }
    }
}

