/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.jboss.security.auth.spi.Util;
import org.jboss.security.plugins.TransactionManagerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseServerLoginModule
extends UsernamePasswordLoginModule {
    protected String dsJndiName;
    protected String principalsQuery = "select Password from Principals where PrincipalID=?";
    protected String rolesQuery;
    protected boolean suspendResume = true;
    protected String TX_MGR_JNDI_NAME = "java:/TransactionManager";
    protected TransactionManager tm = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String jname;
        Object tmp;
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dsJndiName = (String)options.get("dsJndiName");
        if (this.dsJndiName == null) {
            this.dsJndiName = "java:/DefaultDS";
        }
        if ((tmp = options.get("principalsQuery")) != null) {
            this.principalsQuery = tmp.toString();
        }
        if ((tmp = options.get("rolesQuery")) != null) {
            this.rolesQuery = tmp.toString();
        }
        if ((tmp = options.get("suspendResume")) != null) {
            this.suspendResume = Boolean.valueOf(tmp.toString());
        }
        if (this.trace) {
            this.log.trace((Object)("DatabaseServerLoginModule, dsJndiName=" + this.dsJndiName));
            this.log.trace((Object)("principalsQuery=" + this.principalsQuery));
            if (this.rolesQuery != null) {
                this.log.trace((Object)("rolesQuery=" + this.rolesQuery));
            }
            this.log.trace((Object)("suspendResume=" + this.suspendResume));
        }
        if ((jname = (String)options.get("transactionManagerJndiName")) != null) {
            this.TX_MGR_JNDI_NAME = jname;
        }
        try {
            if (this.suspendResume) {
                this.tm = this.getTransactionManager();
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("PB00019: Processing Failed:Unable to get Transaction Manager", e);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    protected String getUsersPassword() throws LoginException {
        String password;
        block38: {
            Exception e3;
            Transaction tx;
            ResultSet rs;
            Statement ps;
            Connection conn;
            block34: {
                block33: {
                    boolean trace = this.log.isTraceEnabled();
                    String username = this.getUsername();
                    password = null;
                    conn = null;
                    ps = null;
                    rs = null;
                    tx = null;
                    if (this.suspendResume) {
                        try {
                            if (this.tm == null) {
                                throw new IllegalStateException("PB00015: Null Value:Transaction Manager is null");
                            }
                            tx = this.tm.suspend();
                        }
                        catch (SystemException e2) {
                            throw new RuntimeException(e2);
                        }
                        if (trace) {
                            this.log.trace((Object)"suspendAnyTransaction");
                        }
                    }
                    InitialContext ctx = new InitialContext();
                    DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
                    conn = ds.getConnection();
                    if (trace) {
                        this.log.trace((Object)("Excuting query: " + this.principalsQuery + ", with username: " + username));
                    }
                    ps = conn.prepareStatement(this.principalsQuery);
                    ps.setString(1, username);
                    rs = ps.executeQuery();
                    if (!rs.next()) {
                        if (trace) {
                            this.log.trace((Object)"Query returned no matches from db");
                        }
                        throw new FailedLoginException("PB00019: Processing Failed:No matching username found in Principals");
                    }
                    password = rs.getString(1);
                    password = this.convertRawPassword(password);
                    if (!trace) break block33;
                    this.log.trace((Object)"Obtained user password");
                }
                Object var11_15 = null;
                if (rs == null) break block34;
                try {
                    rs.close();
                }
                catch (SQLException e3) {
                    // empty catch block
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e3) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
            if (!this.suspendResume) break block38;
            try {
                this.tm.resume(tx);
            }
            catch (Exception e3) {
                throw new RuntimeException(e3);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"resumeAnyTransaction");
            }
            break block38;
            {
                catch (NamingException ex) {
                    LoginException le = new LoginException("PB00019: Processing Failed:Error looking up DataSource from: " + this.dsJndiName);
                    le.initCause(ex);
                    throw le;
                }
                catch (SQLException ex) {
                    LoginException le = new LoginException("PB00019: Processing Failed:Query failed");
                    le.initCause(ex);
                    throw le;
                }
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e3) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e3) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                }
                if (this.suspendResume) {
                    try {
                        this.tm.resume(tx);
                    }
                    catch (Exception e3) {
                        throw new RuntimeException(e3);
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"resumeAnyTransaction");
                    }
                }
                throw throwable;
            }
        }
        return password;
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        if (this.rolesQuery != null) {
            String username = this.getUsername();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("getRoleSets using rolesQuery: " + this.rolesQuery + ", username: " + username));
            }
            Group[] roleSets = Util.getRoleSets(username, this.dsJndiName, this.rolesQuery, this, this.suspendResume);
            return roleSets;
        }
        return new Group[0];
    }

    protected String convertRawPassword(String rawPassword) {
        return rawPassword;
    }

    protected TransactionManager getTransactionManager() throws NamingException {
        TransactionManagerLocator tml = new TransactionManagerLocator();
        return tml.getTM(this.TX_MGR_JNDI_NAME);
    }
}

