/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.rest.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import org.apache.camel.component.platform.http.PlatformHttpConstants;
import org.junit.jupiter.api.Test;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.is;

@QuarkusTest
class RestTest {
    @Test
    public void inspectConfiguration() {
        RestAssured.when()
                .get("/rest/inspect/configuration")
                .then()
                .statusCode(200)
                .body("component", is(PlatformHttpConstants.PLATFORM_HTTP_COMPONENT_NAME));
    }

    @Test
    public void rest() throws Throwable {
        RestAssured.get("/rest/get")
                .then().body(equalTo("GET: /rest/get"));
        RestAssured.given()
                .contentType("text/plain")
                .post("/rest/post")
                .then().body(equalTo("POST: /rest/post"));
    }

    @Test
    public void lightweight() throws Throwable {
        RestAssured.when()
                .get("/rest/inspect/camel-context/lightweight")
                .then()
                .statusCode(200)
                .body(is("true"));
    }

}
