/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.util.Calendar;
import org.jboss.logging.Logger;
import org.jboss.ws.extensions.security.FailedCheckException;
import org.jboss.ws.extensions.security.WSSecurityException;
import org.jboss.ws.extensions.security.element.Timestamp;
import org.jboss.ws.metadata.wsse.TimestampVerification;
import org.w3c.dom.Document;

public class TimestampVerificationOperation {
    private static final Logger log = Logger.getLogger(TimestampVerificationOperation.class);
    private TimestampVerification timestampVerification;
    private Calendar now = null;

    public TimestampVerificationOperation(TimestampVerification timestampVerification) {
        this.timestampVerification = timestampVerification;
    }

    public TimestampVerificationOperation(Calendar now) {
        this.now = now;
    }

    public void process(Document message, Timestamp timestamp) throws WSSecurityException {
        boolean rejectExpires;
        Calendar now;
        Calendar expires = timestamp.getExpires();
        Calendar created = timestamp.getCreated();
        boolean rejectCreated = created.after(now = this.now == null ? Calendar.getInstance() : this.now);
        if (rejectCreated && this.timestampVerification != null && this.timestampVerification.getCreatedTolerance() > 0L) {
            Calendar tolerantCreatedNow = (Calendar)now.clone();
            tolerantCreatedNow.add(13, (int)this.timestampVerification.getCreatedTolerance());
            rejectCreated = created.after(tolerantCreatedNow);
            if (!rejectCreated && this.timestampVerification.isWarnCreated()) {
                log.warn((Object)"Accepting Timestamp with 'Created' after now but within configured tolerance.");
            }
        }
        if (rejectCreated) {
            throw new WSSecurityException("Invalid timestamp, message claimed to be created after now");
        }
        boolean bl = rejectExpires = expires != null && !now.before(expires);
        if (rejectExpires && this.timestampVerification != null && this.timestampVerification.getExpiresTolerance() > 0L) {
            Calendar tolerantExpiresNow = (Calendar)now.clone();
            tolerantExpiresNow.add(13, (int)this.timestampVerification.getExpiresTolerance() * -1);
            boolean bl2 = rejectExpires = !tolerantExpiresNow.before(expires);
            if (!rejectExpires && this.timestampVerification.isWarnExpires()) {
                log.warn((Object)"Accepting Timestamp with 'Expires' in past but within configured tolerance.");
            }
        }
        if (rejectExpires) {
            throw new FailedCheckException("Expired message.");
        }
    }
}

