/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.jboss.ws.extensions.security.FailedCheckException;
import org.jboss.ws.extensions.security.RequireOperation;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.Target;
import org.jboss.ws.extensions.security.WSSecurityException;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.Timestamp;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequireTimestampOperation
implements RequireOperation {
    private SecurityHeader header;

    public RequireTimestampOperation(SecurityHeader header, SecurityStore store) throws WSSecurityException {
        this.header = header;
    }

    @Override
    public void process(Document message, List<Target> targets, String maxAge, String credential, Collection<String> processedIds) throws WSSecurityException {
        Timestamp stamp = this.header.getTimestamp();
        if (stamp == null) {
            throw new FailedCheckException("Required timestamp not present.");
        }
        if (maxAge == null) {
            return;
        }
        int max = Integer.parseInt(maxAge);
        Calendar expired = (Calendar)stamp.getCreated().clone();
        expired.add(13, max);
        if (!Calendar.getInstance().before(expired)) {
            throw new FailedCheckException("Timestamp of message is too old.");
        }
    }
}

