/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.soap.SOAPFaultException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.StubExt;
import org.jboss.ws.core.jaxrpc.client.CallImpl;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.wsf.common.JavaUtils;

public class PortProxy
implements InvocationHandler {
    private static final Logger log = Logger.getLogger(PortProxy.class);
    private CallImpl call;
    private List stubMethods;
    private List objectMethods;
    private static final Set<String> standardProperties = new HashSet<String>();
    private static final Map<String, String> legacyPropertyMap;

    public PortProxy(CallImpl call) {
        this.call = call;
        this.stubMethods = new ArrayList<Method>(Arrays.asList(StubExt.class.getMethods()));
        this.stubMethods.addAll(Arrays.asList(Stub.class.getMethods()));
        this.objectMethods = Arrays.asList(Object.class.getMethods());
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (this.stubMethods.contains(method)) {
            if (methodName.equals("_getPropertyNames")) {
                return this.call.getPropertyNames();
            }
            if (methodName.equals("_getProperty")) {
                return this.getProperty((String)args[0]);
            }
            if (methodName.equals("_setProperty")) {
                this.setProperty((String)args[0], args[1]);
                return null;
            }
            Method callMethod = CallImpl.class.getMethod(methodName, method.getParameterTypes());
            return callMethod.invoke((Object)this.call, args);
        }
        if (this.objectMethods.contains(method)) {
            Method callMethod = CallImpl.class.getMethod(methodName, method.getParameterTypes());
            return callMethod.invoke((Object)this.call, args);
        }
        EndpointMetaData epMetaData = this.call.getEndpointMetaData();
        OperationMetaData opMetaData = epMetaData.getOperation(method);
        if (opMetaData == null) {
            throw new WSException("Cannot obtain operation meta data for: " + methodName);
        }
        this.call.setOperationName(opMetaData.getQName());
        try {
            if (opMetaData.isOneWay()) {
                this.call.invokeOneWay(args);
                return null;
            }
            Object retObj = this.call.invoke(args);
            if (retObj != null) {
                Class<?> retType = method.getReturnType();
                if (retType == null) {
                    throw new WSException("Return value not supported by: " + opMetaData);
                }
                if (JavaUtils.isPrimitive(retType)) {
                    retObj = JavaUtils.getPrimitiveValueArray((Object)retObj);
                }
            }
            return retObj;
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    private Object getProperty(String name) {
        name = this.assertPropertyName(name);
        return this.call.getProperty(name);
    }

    private void setProperty(String name, Object value) {
        name = this.assertPropertyName(name);
        this.call.setProperty(name, value);
    }

    private String assertPropertyName(String name) {
        if (name != null && name.startsWith("javax.xml.rpc") && !standardProperties.contains(name)) {
            throw new JAXRPCException("Unsupported property: " + name);
        }
        if (legacyPropertyMap.keySet().contains(name)) {
            String jbosswsName = legacyPropertyMap.get(name);
            log.warn((Object)("Legacy propery '" + name + "' mapped to '" + jbosswsName + "'"));
            name = jbosswsName;
        }
        return name;
    }

    private void handleException(Exception ex) throws Throwable {
        SOAPFaultException faultEx;
        Throwable th = ex;
        if (ex instanceof RemoteException && ex.getCause() instanceof SOAPFaultException && (faultEx = (SOAPFaultException)ex.getCause()).getCause() != null) {
            th = faultEx.getCause();
        }
        throw th;
    }

    static {
        standardProperties.add("javax.xml.rpc.service.endpoint.address");
        standardProperties.add("javax.xml.rpc.session.maintain");
        standardProperties.add("javax.xml.rpc.security.auth.username");
        standardProperties.add("javax.xml.rpc.security.auth.password");
        legacyPropertyMap = new HashMap<String, String>();
        legacyPropertyMap.put("org.jboss.webservice.client.timeout", "org.jboss.ws.timeout");
        legacyPropertyMap.put("org.jboss.webservice.keyAlias", "org.jboss.ws.keyAlias");
        legacyPropertyMap.put("org.jboss.webservice.keyStore", "org.jboss.ws.keyStore");
        legacyPropertyMap.put("org.jboss.webservice.keyStoreAlgorithm", "org.jboss.ws.keyStoreAlgorithm");
        legacyPropertyMap.put("org.jboss.webservice.keyStorePassword", "org.jboss.ws.keyStorePassword");
        legacyPropertyMap.put("org.jboss.webservice.keyStoreType", "org.jboss.ws.keyStoreType");
        legacyPropertyMap.put("org.jboss.webservice.sslProtocol", "org.jboss.ws.sslProtocol");
        legacyPropertyMap.put("org.jboss.webservice.sslProviderName", "org.jboss.ws.sslProviderName");
        legacyPropertyMap.put("org.jboss.webservice.trustStore", "org.jboss.ws.trustStore");
        legacyPropertyMap.put("org.jboss.webservice.trustStoreAlgorithm", "org.jboss.ws.trustStoreAlgorithm");
        legacyPropertyMap.put("org.jboss.webservice.trustStorePassword", "org.jboss.ws.trustStorePassword");
        legacyPropertyMap.put("org.jboss.webservice.trustStoreType", "org.jboss.ws.trustStoreType");
    }
}

