/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2022, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.test.clustering.cluster.web.authentication;

import java.io.File;

import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.wildfly.test.security.common.elytron.ElytronDomainSetup;
import org.wildfly.test.security.common.elytron.ServletElytronDomainSetup;

public class AuthenticationSecurityDomainSetup implements ServerSetupTask {

    private static final boolean USE_ELYTRON = System.getProperty("elytron") != null;
    private static final String SECURITY_DOMAIN_NAME = "authentication";

    private WebSecurityDomainSetup legacySecurityDomainSetup;
    private ElytronDomainSetup elytronDomainSetup;
    private ServletElytronDomainSetup servletElytronDomainSetup;

    @Override
    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        if (USE_ELYTRON) {
            elytronDomainSetup = new ElytronDomainSetup(getUsersFile(), getGroupsFile(), SECURITY_DOMAIN_NAME);
            servletElytronDomainSetup = new ServletElytronDomainSetup(SECURITY_DOMAIN_NAME, false);

            elytronDomainSetup.setup(managementClient, containerId);
            servletElytronDomainSetup.setup(managementClient, containerId);
        } else {
            legacySecurityDomainSetup = new WebSecurityDomainSetup();
            legacySecurityDomainSetup.setup(managementClient, containerId);
        }
    }

    @Override
    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        if (USE_ELYTRON) {
            elytronDomainSetup.tearDown(managementClient, containerId);
            servletElytronDomainSetup.tearDown(managementClient, containerId);
        } else {
            legacySecurityDomainSetup.tearDown(managementClient, containerId);
        }
    }

    private static String getUsersFile() {
        return new File(FormAuthenticationWebFailoverTestCase.class.getResource("users.properties").getFile()).getAbsolutePath();
    }

    private static String getGroupsFile() {
        return new File(FormAuthenticationWebFailoverTestCase.class.getResource("roles.properties").getFile()).getAbsolutePath();
    }
}
