/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.test.integration.domain;

import org.jboss.as.test.integration.domain.management.util.DomainTestSupport;
import org.jboss.as.test.shared.AssumeTestGroupUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.Assert;

import java.io.File;

/**
 * Tests server identity configuration on host in case kerberos is used for server identity
 * @author Vlado Pakan
 */
public class KerberosServerIdentityTestCase {

    @BeforeClass
    public static void setUp() throws Exception {
        // Legacy security won't work on SE 14 or later; 11 is the last SE where EAP will support it
        AssumeTestGroupUtil.assumeJDKVersionBefore(12);
    }

    @Test
    public void testServerResolvesKeytabNode() throws Throwable {
        DomainTestSupport testSupport = null;
        File keytabFile = null;
        boolean keytabFileCreated = false;
        try {
            testSupport = DomainTestSupport.create(DomainTestSupport.Configuration.create(
                    KerberosServerIdentityTestCase.class.getSimpleName(), "domain-configs/domain-minimal.xml",
                    "host-configs/host-master-kerberos.xml", "host-configs/host-slave-kerberos.xml"));
            // create dummy keytab file
            final String keytabFileName = "dummy.keytab";
            keytabFile = new File(testSupport.getDomainSlaveConfiguration().getJbossHome(),keytabFileName);
            keytabFileCreated = keytabFile.createNewFile();
            // start server
            testSupport.start();
        } catch (Throwable e) {
            Assert.fail("Server did not start properly.");
        } finally {
            if (testSupport != null) {
                testSupport.close();
                testSupport = null;
            }
            if (keytabFileCreated){
                keytabFile.delete();
            }
        }
    }
}
