/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewDeclarationLanguage;
import org.apache.myfaces.application.TreeStructureManager;
import org.apache.myfaces.application.viewstate.StateCacheUtils;
import org.apache.myfaces.context.RequestViewContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManagerImpl
extends StateManager {
    private static final Logger log = Logger.getLogger(StateManagerImpl.class.getName());
    private static final String SERIALIZED_VIEW_REQUEST_ATTR = StateManagerImpl.class.getName() + ".SERIALIZED_VIEW";
    private static final String IS_SAVING_STATE = "javax.faces.IS_SAVING_STATE";
    private RenderKitFactory _renderKitFactory = null;

    protected Object getComponentStateToSave(FacesContext facesContext) {
        UIViewRoot viewRoot;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering getComponentStateToSave");
        }
        if ((viewRoot = facesContext.getViewRoot()).isTransient()) {
            return null;
        }
        Object serializedComponentStates = viewRoot.processSaveState(facesContext);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting getComponentStateToSave");
        }
        return serializedComponentStates;
    }

    protected Object getTreeStructureToSave(FacesContext facesContext) {
        UIViewRoot viewRoot;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering getTreeStructureToSave");
        }
        if ((viewRoot = facesContext.getViewRoot()).isTransient()) {
            return null;
        }
        TreeStructureManager tsm = new TreeStructureManager();
        Object retVal = tsm.buildTreeStructureToSave(viewRoot);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting getTreeStructureToSave");
        }
        return retVal;
    }

    public UIViewRoot restoreView(FacesContext facesContext, String viewId, String renderKitId) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering restoreView - viewId: " + viewId + " ; renderKitId: " + renderKitId);
        }
        UIViewRoot uiViewRoot = null;
        ViewDeclarationLanguage vdl = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, viewId);
        StateManagementStrategy sms = null;
        if (vdl != null) {
            sms = vdl.getStateManagementStrategy(facesContext, viewId);
        }
        if (sms != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Redirect to StateManagementStrategy: " + sms.getClass().getName());
            }
            uiViewRoot = sms.restoreView(facesContext, viewId, renderKitId);
        } else {
            Object[] stateArray;
            TreeStructureManager tsm;
            RenderKit renderKit = this.getRenderKitFactory().getRenderKit(facesContext, renderKitId);
            ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
            Object state = responseStateManager.getState(facesContext, viewId);
            if (state != null && (uiViewRoot = (tsm = new TreeStructureManager()).restoreTreeStructure((stateArray = (Object[])state)[0])) != null) {
                facesContext.setViewRoot(uiViewRoot);
                uiViewRoot.processRestoreState(facesContext, stateArray[1]);
                RequestViewContext.getCurrentInstance(facesContext).refreshRequestViewContext(facesContext, uiViewRoot);
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting restoreView - " + viewId);
        }
        return uiViewRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object saveView(FacesContext facesContext) {
        Object serializedView = null;
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        ResponseStateManager responseStateManager = facesContext.getRenderKit().getResponseStateManager();
        String viewId = uiViewRoot.getViewId();
        ViewDeclarationLanguage vdl = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, viewId);
        try {
            StateManagementStrategy sms;
            facesContext.getAttributes().put(IS_SAVING_STATE, Boolean.TRUE);
            if (vdl != null && (sms = vdl.getStateManagementStrategy(facesContext, viewId)) != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Calling saveView of StateManagementStrategy: " + sms.getClass().getName());
                }
                serializedView = sms.saveView(facesContext);
                if (StateCacheUtils.isMyFacesResponseStateManager(responseStateManager)) {
                    StateCacheUtils.getMyFacesResponseStateManager(responseStateManager).saveState(facesContext, serializedView);
                }
                Object[] objectArray = serializedView;
                return objectArray;
            }
            if (uiViewRoot.isTransient()) {
                sms = null;
                return sms;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Entering saveSerializedView");
            }
            StateManagerImpl.checkForDuplicateIds(facesContext, (UIComponent)facesContext.getViewRoot(), new HashSet<String>());
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Processing saveSerializedView - Checked for duplicate Ids");
            }
            ExternalContext externalContext = facesContext.getExternalContext();
            serializedView = facesContext.getAttributes().get(SERIALIZED_VIEW_REQUEST_ATTR);
            if (serializedView == null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Processing saveSerializedView - create new serialized view");
                }
                Object treeStruct = this.getTreeStructureToSave(facesContext);
                Object compStates = this.getComponentStateToSave(facesContext);
                serializedView = new Object[]{treeStruct, compStates};
                facesContext.getAttributes().put(SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Processing saveSerializedView - new serialized view created");
                }
            }
            if (StateCacheUtils.isMyFacesResponseStateManager(responseStateManager)) {
                StateCacheUtils.getMyFacesResponseStateManager(responseStateManager).saveState(facesContext, serializedView);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Exiting saveView");
            }
        }
        finally {
            facesContext.getAttributes().remove(IS_SAVING_STATE);
        }
        return serializedView;
    }

    private static void checkForDuplicateIds(FacesContext context, UIComponent component, Set<String> ids) {
        int facetCount;
        String id = component.getId();
        if (id != null && !ids.add(id)) {
            throw new IllegalStateException("Client-id : " + id + " is duplicated in the faces tree. Component : " + component.getClientId(context) + ", path: " + StateManagerImpl.getPathToComponent(component));
        }
        if (component instanceof NamingContainer) {
            ids = new HashSet<String>();
        }
        if ((facetCount = component.getFacetCount()) > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                StateManagerImpl.checkForDuplicateIds(context, facet, ids);
            }
        }
        int childCount = component.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = (UIComponent)component.getChildren().get(i);
            StateManagerImpl.checkForDuplicateIds(context, child, ids);
        }
    }

    private static String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        StateManagerImpl.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private static void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, intBuf.toString());
        StateManagerImpl.getPathToComponent(component.getParent(), buf);
    }

    public void writeState(FacesContext facesContext, Object state) throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering writeState");
        }
        RenderKit renderKit = facesContext.getRenderKit();
        ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
        responseStateManager.writeState(facesContext, state);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting writeState");
        }
    }

    protected RenderKitFactory getRenderKitFactory() {
        if (this._renderKitFactory == null) {
            this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        }
        return this._renderKitFactory;
    }
}

