/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.test.integration.ws.wsrm;

import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.test.integration.ws.wsrm.generated.ReliableService;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * BZ-1223698
 *
 * @author <a href="mailto:rsvoboda@redhat.com">Rostislav Svoboda</a>
 * @author <a href="mailto:thofman@redhat.com">Tomas Hofman</a>
 */
@RunWith(Arquillian.class)
@RunAsClient
public class ReliableServiceWithRMTxStoreTestCase {

    private static final Logger log = Logger.getLogger(ReliableServiceWithRMTxStoreTestCase.class);
    @ArquillianResource
    URL baseUrl;

    @Deployment(testable = false)
    public static Archive mainDeployment() {
        WebArchive war = ShrinkWrap.create(WebArchive.class, "ws-reliable-messaging-rmtxstore-example.war").
                addPackage(ReliableService.class.getPackage()).
                addClasses(ReliableServiceWithRMTxStoreImpl.class, ReliableCheckHandler.class, RMStoreFeature.class).
                addAsWebInfResource(ReliableServiceWithRMTxStoreTestCase.class.getPackage(), "ReliableService.wsdl", "wsdl/ReliableService.wsdl").
                addAsWebInfResource(ReliableServiceWithRMTxStoreTestCase.class.getPackage(), "jboss-deployment-structure.xml", "jboss-deployment-structure.xml").
                addAsResource(ReliableCheckHandler.class.getPackage(), "ws-handler.xml", "org/jboss/as/test/integration/ws/wsrm/ws-handler.xml");

        log.debug(war.toString(true));
        return war;
    }

    @Test
    public void consumeOneWayService() throws Exception {
        QName serviceName = new QName("http://www.jboss.org/jbossws/ws-extensions/wsrm", "ReliableService");
        URL wsdlURL = new URL(baseUrl, "ReliableService?wsdl");
        Service service = Service.create(wsdlURL, serviceName);
        ReliableService proxy = service.getPort(ReliableService.class);

        BindingProvider bp = (BindingProvider) proxy;
        bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, new URL(baseUrl, "ReliableService").toString());

        try {
            proxy.writeLogMessage();
        } catch (SOAPFaultException e) {
            Assert.fail("BZ 1223698"); // should be fixed by upgrade to Apache CXF-2.7.17
        }
    }

}
