/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2015, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.wildfly.test.integration.ejb.java8.staticMethodInView;

import javax.inject.Inject;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.classfilewriter.InvalidBytecodeException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * Verifies that deployment does not fail with {@link InvalidBytecodeException} if EJB's local interface declares a static
 * method (Java 8 feature).
 * <p>
 * Once the WFLY-4316/BZ1346242 is fixed in jboss-invocation, this test case is designed to pass both on Java 7 and Java 8.
 * Before WFLY-4316/BZ1346242 is fixed in jboss-invocation, this test case will pass on Java 7 but it will fail on Java 8.
 * <p>
 * See WFLY-4316 and BZ1346242 for further details.
 *
 * @author Jozef Hartinger
 * @author <a href="https://github.com/ppalaga">Peter Palaga</a>
 */
@RunWith(Arquillian.class)
public class StaticMethodOnEjbViewTestCase {

    @Inject
    private Airplane airplane;

    @Deployment
    public static Archive<?> getDeployment() {
        return ShrinkWrap.create(WebArchive.class).addPackage(StaticMethodOnEjbViewTestCase.class.getPackage())
                .addAsWebInfResource(EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testDeploymentWorks() {
        Assert.assertNotNull(airplane);
        Assert.assertTrue(airplane.takeOff());
    }

}