/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012, Red Hat Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.test.integration.deployment.parsing;

import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

import javax.naming.NamingException;

/**
 * Test case for https://bugzilla.redhat.com/show_bug.cgi?id=1184292
 * 
 * @author Tomas Hofman
 */
@RunWith(Arquillian.class)
public class BrokenWebXmlTestCase {
    private static final Logger log = Logger.getLogger(BrokenWebXmlTestCase.class);
    private static final String ARCHIVE_NAME = "deployment";

    @ArquillianResource
    private Deployer deployer;

    @Deployment(name = "test", managed = false)
    public static Archive<?> deploy() {
        WebArchive war = ShrinkWrap.create(WebArchive.class, ARCHIVE_NAME + ".war");
        war.addAsWebInfResource(BrokenWebXmlTestCase.class.getPackage(), "web-shift-jis.xml", "web.xml"); // web.xml with incorrect encoding
        return war;
    }

    @Test
    public void testBrokenWebXml() throws NamingException {
        try {
            deployer.deploy("test");
        } catch (Exception e) {
            log.debug("Exception thrown by deployer is:", e);
            Throwable cause = e.getCause();
            Assert.assertFalse("Deployer reported NullPointerException instead of DeploymentUnitProcessingException -- NPE during exception handling: "
                    + cause.getMessage(),
                    cause.getMessage().contains("Caused by: java.lang.NullPointerException"));
            return;
        }
        Assert.fail("Deployment was expected to fail.");
    }

}
