/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2016, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.test.integration.domain.ds;

import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;

/**
 * @author baranowb
 *
 */
public class XADSOnOff_1_0_TestCase extends DSOnOffTestBase {

    /* (non-Javadoc)
     * @see org.jboss.as.test.integration.domain.ds.DSOnOffTestBase#getDomainXML()
     */
    @Override
    protected String getDomainXML() {
        return "domain-standard-xads-1.0.xml";
    }

    /* (non-Javadoc)
     * @see org.jboss.as.test.integration.domain.ds.DSOnOffTestBase#getAddressResource()
     */
    @Override
    protected ModelNode getAddressResource() {
        return PathAddress.pathAddress("host", "host-ds")
                .append("server", "server-one")
                .append("subsystem", "datasources")
                .append("xa-data-source", "ExampleXADS").toModelNode();
    }

    /* (non-Javadoc)
     * @see org.jboss.as.test.integration.domain.ds.DSOnOffTestBase#getAddressConfiguration()
     */
    @Override
    protected ModelNode getAddressConfiguration() {

        return PathAddress.pathAddress()
                .append("profile", "default")
                .append("subsystem", "datasources")
                .append("xa-data-source", "ExampleXADS").toModelNode();
    }

}
