package org.jboss.as.domain.management.security;

import org.jboss.msc.service.StartException;
import org.junit.Assert;
import org.junit.Test;

import java.io.File;
import java.net.URISyntaxException;

import static org.jboss.as.domain.management.DomainManagementMessages.MESSAGES;

/**
 * @author Tomas Hofman (thofman@redhat.com)
 */
public class JKSKeystoreTestCase {

    private static final String KEYSTORE = "keystore.jks";
    private static final String ALIAS = "jboss";
    private static final String PASSWORD = "changeit";

    @Test
    public void testWrongAlias() throws URISyntaxException, StartException {
        try {
            String path = new File(getClass().getResource(KEYSTORE).toURI()).getAbsolutePath();
            JKSKeystore keystore = JKSKeystore.newKeyStore(path, PASSWORD.toCharArray(), PASSWORD.toCharArray(), "wrongalias");
            keystore.load();
            Assert.fail("StartException expected.");
        } catch (StartException e) {
            StartException expectedException = MESSAGES.wrongKeyStoreAlias("");
            String assertMessage = String.format("Expecting error message starting with '%s', got '%s' instead.",
                    expectedException.getMessage(), e.getMessage());
            Assert.assertTrue(assertMessage, e.getMessage().startsWith(expectedException.getMessage()));
        }
    }

    @Test
    public void testNotExistingKeystore() throws URISyntaxException, StartException {
        try {
            String path = new File(getClass().getResource(KEYSTORE).toURI().resolve("not-existing.jks")).getAbsolutePath();
            JKSKeystore keystore = JKSKeystore.newKeyStore(path, PASSWORD.toCharArray(), PASSWORD.toCharArray(), ALIAS);
            keystore.load();
            Assert.fail("StartException expected.");
        } catch (StartException e) {
            StartException expectedException = MESSAGES.keyStoreNotFound("");
            String assertMessage = String.format("Expecting error message starting with '%s', got '%s' instead.",
                    expectedException.getMessage(), e.getMessage());
            Assert.assertTrue(assertMessage, e.getMessage().startsWith(expectedException.getMessage()));
        }
    }

    @Test
    public void testNotExistingKeystoreAndNoAlias() throws URISyntaxException, StartException {
        String path = new File(getClass().getResource(KEYSTORE).toURI().resolve("not-existing.jks")).getAbsolutePath();
        JKSKeystore keystore = JKSKeystore.newKeyStore(path, PASSWORD.toCharArray(), PASSWORD.toCharArray(), null);
        keystore.load();
    }

    @Test
    public void testCorrectKeystore() throws URISyntaxException, StartException {
        String path = new File(getClass().getResource(KEYSTORE).toURI()).getAbsolutePath();
        JKSKeystore keystore = JKSKeystore.newKeyStore(path, PASSWORD.toCharArray(), PASSWORD.toCharArray(), ALIAS);
        keystore.load();
    }
}
