/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.cli.handlers;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.junit.Before;
import org.junit.Test;

import java.util.Collections;

import static junit.framework.TestCase.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.spy;
import static org.mockito.Mockito.when;
import static org.mockito.Mockito.doReturn;

/**
 * Mock test mainly for fix of BZ-1467848
 */
public class GenericTypeOperationHandlerMockTest {

    private GenericTypeOperationHandler operationHandler;
    private CommandContext context = mock(CommandContext.class);

    @Before
    public void before() {
        operationHandler = new GenericTypeOperationHandler(context, "test", "test");
    }

    /**
     * Test for BZ 1467848
     *
     * @throws Exception Should not happen.
     */
    @Test
    public void testAsType() throws Exception {
        ModelNode node1 = mock(ModelNode.class);
        //reason of defect is, that asType() throws IllegalArgumentException
        when(node1.asType()).thenThrow(new IllegalArgumentException());

        //in case of IllegalArgumentException there should be no exception caught
        try {
            testAsTypeWithNode(node1);
        } catch (Exception e) {
            assertNull("Exception should not be  thrown", e);
        }

        ModelNode node2 = mock(ModelNode.class);
        // if exception is different, it should e propagated
        when(node2.asType()).thenThrow(new RuntimeException());

        //in case of IllegalArgumentException there should be no exception caught
        try {
            testAsTypeWithNode(node2);
        } catch (Exception e){
            assertNotNull("Exception should be thrown", e);
        }

    }

    /**
     * Call of asType in the GenericTypeOperationHandler with mocks  .
     * taking the easiest approach.
     *
     * @param node Node which could have different behavior
     * @throws Exception Should not happen.
     */
    private void testAsTypeWithNode(ModelNode node) throws Exception {
        ParsedCommandLine parsedCommandLine = mock(ParsedCommandLine.class);
        when(parsedCommandLine.hasProperties()).thenReturn(true);
        when(parsedCommandLine.hasProperty("--test")).thenReturn(true);

        when(context.getParsedCommandLine()).thenReturn(parsedCommandLine);


        GenericTypeOperationHandler.AttributeDescription desc = mock(GenericTypeOperationHandler.AttributeDescription.class);
        when(desc.isWriteAllowed()).thenReturn(true);

        //one method on handler has to be mocked
        GenericTypeOperationHandler handler = spy(operationHandler);
        doReturn(Collections.singletonList(desc).iterator()).when(handler).getNodeProperties(context);

        when(desc.getName()).thenReturn("test");
        when(desc.getType()).thenReturn(ModelType.LIST);
        when(desc.getProperty(Util.VALUE_TYPE)).thenReturn(node);

        //call handler
        handler.getArguments(context);
    }
}
