/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class LimitedBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final BlockingQueue<E> delegate;
    private volatile int count;
    private static final AtomicIntegerFieldUpdater<LimitedBlockingQueue> countUpdater = AtomicIntegerFieldUpdater.newUpdater(LimitedBlockingQueue.class, "count");

    LimitedBlockingQueue(BlockingQueue<E> delegate, int count) {
        this.delegate = delegate;
        this.count = count;
    }

    @Override
    public boolean add(E e) {
        if (!this.offer(e)) {
            throw new IllegalStateException();
        }
        return true;
    }

    @Override
    public boolean offer(E e) {
        int count = countUpdater.getAndDecrement(this);
        if (count <= 0) {
            countUpdater.getAndIncrement(this);
            return false;
        }
        if (!this.delegate.offer(e)) {
            countUpdater.getAndIncrement(this);
            return false;
        }
        return true;
    }

    public boolean offerUnchecked(E e) {
        countUpdater.decrementAndGet(this);
        if (!this.delegate.offer(e)) {
            countUpdater.getAndIncrement(this);
            return false;
        }
        return true;
    }

    @Override
    public void put(E e) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public E poll() {
        Object result = this.delegate.poll();
        if (result != null) {
            countUpdater.getAndIncrement(this);
        }
        return result;
    }

    @Override
    public E peek() {
        return this.delegate.peek();
    }

    @Override
    public E take() throws InterruptedException {
        E result = this.delegate.take();
        if (result != null) {
            countUpdater.getAndIncrement(this);
        }
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator iterator = this.delegate.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
                countUpdater.getAndIncrement(LimitedBlockingQueue.this);
            }
        };
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E result = this.delegate.poll(timeout, unit);
        if (result != null) {
            countUpdater.getAndIncrement(this);
        }
        return result;
    }

    @Override
    public int remainingCapacity() {
        return countUpdater.get(this);
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        int res = this.delegate.drainTo(c);
        countUpdater.getAndAdd(this, res);
        return res;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int res = this.delegate.drainTo(c, maxElements);
        countUpdater.getAndAdd(this, res);
        return res;
    }
}

