package org.jboss.as.messaging;

import org.hornetq.core.server.JournalType;

public final class DefaultConfigurationValues {

    public static final boolean ALLOW_AUTO_FAILBACK = true;

    public static final boolean ASYNC_CONNECTION_EXECUTION_ENABLED = true;

    public static final boolean BACKUP = false;

    public static final long CALL_TIMEOUT = 30000;

    public static final long CALL_FAILOVER_TIMEOUT = -1;

    public static final long CHECK_PERIOD = 30000;

    public static final boolean CHECK_FOR_LIVE_SERVER = false;

    public static final String DEFAULT_CLUSTER_PASSWORD = "CHANGE ME!!";

    public static final String DEFAULT_CLUSTER_USER = "HORNETQ.CLUSTER.ADMIN.USER";

    public static final int CONFIRMATION_WINDOW_SIZE = 1024 * 1024;

    public static final long CONNECTION_TTL = 1 * 60 * 1000;

    public static final long CONNECTION_TTL_OVERRIDE = -1;

    public static final boolean CREATE_BINDINGS_DIR = true;

    public static final boolean CREATE_JOURNAL_DIR = true;

    public static final boolean DURABLE = true;

    public static final long FAILBACK_DELAY = 5000;

    public static final int ID_CACHE_SIZE = 20000;

    public static final String JMX_DOMAIN = "org.hornetq";

    public static final int JOURNAL_COMPACT_MIN_FILES = 10;

    public static final int JOURNAL_COMPACT_PERCENTAGE = 30;

    public static final int JOURNAL_FILE_SIZE = 10485760;

    public static final int JOURNAL_MIN_FILES = 2;

    public static final boolean JOURNAL_SYNC_NON_TRANSACTIONAL = true;

    public static final boolean JOURNAL_SYNC_TRANSACTIONAL = true;

    public static final String JOURNAL_TYPE = JournalType.ASYNCIO.toString();

    public static final boolean JOURNAL_LOG_WRITE_RATE = false;

    public static final String MANAGEMENT_ADDRESS = "jms.queue.hornetq.management";

    public static final String MANAGEMENT_NOTIFICATION_ADDRESS = "hornetq.notifications";

    public static final long MAX_RETRY_INTERVAL = 2000;

    public static final int MAX_SAVED_REPLICATED_JOURNALS_SIZE = 2;

    public static final long MEMORY_MEASURE_INTERVAL = -1;

    public static final int MEMORY_WARNING_THRESHOLD = 25;

    public static final boolean MESSAGE_COUNTER_ENABLED = false;

    public static final int MESSAGE_COUNTER_MAX_DAY_HISTORY = 10;

    public static final long MESSAGE_COUNTER_SAMPLE_PERIOD = 10000;

    public static final long MESSAGE_EXPIRY_SCAN_PERIOD = 30000;

    public static final int MESSAGE_EXPIRY_THREAD_PRIORITY = 3;

    public static final int MIN_LARGE_MESSAGE_SIZE = 100 * 1024;

    public static final int MAX_CONCURRENT_PAGE_IO = 5;

    public static final int JOURNAL_PERF_BLAST_PAGES = -1;

    public static final boolean PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY = false;

    public static final boolean PERSISTENCE_ENABLED = true;

    public static final boolean PERSIST_ID_CACHE = true;

    public static final long RETRY_INTERVAL = 2000;

    public static final double RETRY_INTERVAL_MULTIPLIER = 1d;

    public static final boolean RUN_SYNC_SPEED_TEST = false;

    public static final int SCHEDULED_THREAD_POOL_MAX_SIZE = 5;

    public static final boolean SECURITY_ENABLED = true;

    public static final long SECURITY_INVALIDATION_INTERVAL = 10000;

    public static final long SERVER_DUMP_INTERVAL = -1;

    public static final boolean SHARED_STORE = true;

    public static final int THREAD_POOL_MAX_SIZE = 30;

    public static final long TRANSACTION_TIMEOUT = 300000;

    public static final long TRANSACTION_TIMEOUT_SCAN_PERIOD = 1000;

    public static final boolean WILDCARD_ROUTING_ENABLED = true;

    private DefaultConfigurationValues() {}
}
