/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.test.iiopssl.basic;

import org.jboss.logging.Logger;

import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import java.rmi.RemoteException;

/**
 * @author Bartosz Spyrko-Smietanko
 * @author <a href="mailto:tadamski@redhat.com">Tomasz Adamski</a>
 */
@Stateless
public class ClientEjb {

    Logger log = Logger.getLogger(ClientEjb.class.getName());
    private IIOPSslStatelessHome statelessHome;


    public int getRemoteMessage() throws RemoteException {
        IIOPSslStatelessRemote ejb = statelessHome.create();
        return ejb.hello();
    }

    public int lookup(String host, int port) throws NamingException, RemoteException {
        debug("starting manual lookup test");
        final InitialContext ctx = new InitialContext();
        debug("staring lookup");
        final Object value = ctx.lookup("corbaname:iiop:1.2@" + host + ":" + port + "#IIOPSslStatelessBean");
        debug("lookup result: " + value);

        final Object narrow = PortableRemoteObject.narrow(value, IIOPSslStatelessHome.class);
        debug("After narrow: " + narrow);
        return ((IIOPSslStatelessHome)narrow).create().hello();
    }

    public int lookupSsl(String host, int port) throws NamingException, RemoteException {
        debug("starting manual lookup test");
        final InitialContext ctx = new InitialContext();
        debug("staring lookup");
        final Object value = ctx.lookup("corbaname:ssliop:1.2@" + host + ":" + port + "#IIOPSslStatelessBean");
        debug("lookup result: " + value);

        final Object narrow = PortableRemoteObject.narrow(value, IIOPSslStatelessHome.class);
        debug("After narrow: " + narrow);
        return ((IIOPSslStatelessHome)narrow).create().hello();
    }

    private void debug(String message) {
        if (log.isDebugEnabled())
            log.debug(message);
    }
}

