package org.jboss.as.domain.management.security;

import org.jboss.as.controller.operations.validation.StringBytesLengthValidator;
import org.jboss.msc.service.StartException;
import org.junit.Assert;
import org.junit.Test;

import java.io.File;
import java.net.URISyntaxException;

import static org.jboss.as.domain.management.DomainManagementMessages.MESSAGES;

/**
 * @author Tomas Hofman (thofman@redhat.com)
 */
public class JKSKeystoreTestCase {

    private static final String KEYSTORE_RESOURCE = "keystore.jks";
    private static final String ALIAS = "jboss";
    private static final String PASSWORD = "changeit";

    @Test
    public void testWrongAlias() throws URISyntaxException, StartException {
        try {
            String path = new File(getClass().getResource(KEYSTORE_RESOURCE).toURI()).getAbsolutePath();
            JKSKeystore keystore = JKSKeystore.newKeyStore(path, PASSWORD.toCharArray(), PASSWORD.toCharArray(), "wrongalias");
            keystore.load();
            Assert.fail("StartException expected.");
        } catch (StartException e) {
            StartException expectedException = MESSAGES.wrongKeyStoreAlias("");
            String assertMessage = String.format("Expecting error message starting with '%s', got '%s' instead.",
                    expectedException.getMessage(), e.getMessage());
            Assert.assertTrue(assertMessage, e.getMessage().startsWith(expectedException.getMessage()));
        } catch (Exception e) {
            Assert.fail(String.format("Expected StartException. Got %s instead.", e.getClass().getSimpleName()));
        }
    }

    @Test
    public void testCorrectKeystore() throws URISyntaxException, StartException {
        String path = new File(getClass().getResource(KEYSTORE_RESOURCE).toURI()).getAbsolutePath();
        JKSKeystore keystore = JKSKeystore.newKeyStore(path, PASSWORD.toCharArray(), PASSWORD.toCharArray(), ALIAS);
        keystore.load();
    }
}
