/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2015, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.test.clustering.cluster.cdi;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;

@Path("/")
public class TestResource {

    @Inject
    private SessionBean bean;

    @Context
    private HttpServletRequest httpRequest;

    @Path("/get")
    @GET
    public String get() {
        System.out.println("session id: " + httpRequest.getSession().getId());
        System.out.println("value is: " + bean.getValue());
        return bean.getValue();
    }

    @Path("/set/{value}")
    @GET
    public String set(@PathParam("value") String value) {
        System.out.println("session id: " + httpRequest.getSession().getId());
        System.out.println("setting value: " + value);
        bean.setValue(value);
        return "OK";
    }
}
