/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Method;
import java.util.Map;

import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ejb3.context.EJBContextImpl;
import org.jboss.invocation.Interceptor;
/**
 * @author Stuart Douglas
 */
public abstract class EjbComponentInstance extends BasicComponentInstance {

    private volatile boolean discarded = false;

    private static final Object[] EMPTY_OBJECT_ARRAY = {};
    /**
     * Construct a new instance.
     *
     * @param component the component
     */
    protected EjbComponentInstance(final BasicComponent component, final Interceptor preDestroyInterceptor, final Map<Method, Interceptor> methodInterceptors) {
        super(component, preDestroyInterceptor, methodInterceptors);
    }

    @Override
    public EJBComponent getComponent() {
        return (EJBComponent) super.getComponent();
    }

    public abstract EJBContextImpl getEjbContext();

    public boolean isDiscarded() {
        return discarded;
    }

    public void discard() {
        this.discarded = true;
    }
}
