/*
 * Copyright (C) 2015 Red Hat, inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301  USA
 */
package org.jboss.as.domain.http.server;

import java.io.IOException;
import org.jboss.com.sun.net.httpserver.Filter;
import org.jboss.com.sun.net.httpserver.HttpExchange;


/**
 *
 * @author dpospisi
 */
public class XFrameHeaderFilter extends Filter {

    public static final String X_FRAME_OPTIONS = "X-Frame-Options";
    public static final String SAME_ORIGIN = "SAMEORIGIN";

    public static final String FILTER_DESCRIPTION = "X-Frame-Options header response filter";

    public XFrameHeaderFilter() {
    }

    @Override
    public void doFilter(HttpExchange exchange, Chain chain) throws IOException {
        exchange.getResponseHeaders().add(X_FRAME_OPTIONS, SAME_ORIGIN);
        chain.doFilter(exchange);
    }

    @Override
    public String description() {
        return FILTER_DESCRIPTION;
    }



}
