/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.host.controller;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.ModelDescriptionConstants;
import org.jboss.as.host.controller.model.host.HostResourceDefinition;
import org.jboss.dmr.ModelNode;

/**
 * The directory grouping types for the domains; {@code tmp}, {@code log} and {@code data} directories.
 *
 * @author <a href="mailto:jperkins@redhat.com">James R. Perkins</a>
 */
public enum DirectoryGrouping {


    BY_TYPE("by-type"),
    BY_SERVER("by-server");



    private static final Map<String, DirectoryGrouping> MAP;

    static {
        final Map<String, DirectoryGrouping> map = new HashMap<String, DirectoryGrouping>();
        for (DirectoryGrouping directoryGrouping : values()) {
            map.put(directoryGrouping.localName, directoryGrouping);
        }
        MAP = map;
    }

    public static DirectoryGrouping forName(String localName) {
        final DirectoryGrouping directoryGrouping = localName != null ? MAP.get(localName.toLowerCase()) : null;
        return directoryGrouping == null ? DirectoryGrouping.valueOf(localName.toUpperCase(Locale.ENGLISH)) : directoryGrouping;
    }

    private final String localName;

    DirectoryGrouping(final String localName) {
        this.localName = localName;
    }

    @Override
    public String toString() {
        return localName;
    }

    /**
     * Converts the value of the directory grouping to a model node.
     *
     * @return a new model node for the value.
     */
    public ModelNode toModelNode() {
        return new ModelNode().set(toString());
    }

    /**
     * Returns the default directory grouping.
     *
     * @return the default directory grouping.
     */
    public static DirectoryGrouping defaultValue() {
        return BY_SERVER;
    }
}
