# Copyright (c) 2000-2007, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

%define with()          %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()       %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
%define bcond_with()    %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}

%bcond_without native
%if "%{?rhel}" == "6"
%bcond_without zip
%else
%bcond_with zip
%endif

%define base_name   daemon
%define short_name  commons-%{base_name}

Name:           jakarta-commons-daemon
Version:        1.0.15
Release:        3%{?dist}
Epoch:          1
Summary:        Defines API to support an alternative invocation mechanism
License:        ASL 2.0
Group:          Applications/System
URL:            http://commons.apache.org/daemon/
Source0:        http://www.apache.org/dist/commons/daemon/source/commons-daemon-1.0.14-src.tar.gz
Patch0:          %{name}-crosslink.patch

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%if %with native
BuildRequires:  java-devel
BuildRequires:  libcap-devel
BuildRequires:  docbook-dtds
BuildRequires:  docbook-style-xsl
BuildRequires:  docbook-utils
BuildRequires:  xmlto
BuildRequires:  unzip
%endif
BuildRequires:  jpackage-utils >= 0:1.6
Provides:       %{short_name} = %{epoch}:%{version}-%{release}
Obsoletes:      %{short_name} < %{epoch}:%{version}-%{release}

Requires:       libcap-devel

#win-buildrequires: xbuild

%description
The scope of this package is to define an API in line with the current
Java(tm) Platform APIs to support an alternative invocation mechanism
which could be used instead of the above mentioned public static void
main(String[]) method.  This specification cover the behavior and life
cycle of what we define as Java(tm) daemons, or, in other words, non
interactive Java(tm) applications.

%if %with zip
%package src-zip
Summary:     Container for the source distribution of %{name}
Group:       Development

%description src-zip
Container for the source distribution of %{name}.
%endif

%prep
%setup -q -n %{short_name}-%{version}-src
%patch0 -p0

chmod 644 src/samples/*
%if %with native
# use the one from docbook instead of getting it from the net
catalogfile=`xmlcatalog /etc/xml/catalog "-//OASIS//DTD DocBook XML V4.1.2//EN"|sed -e s:"file\://"::`
sed -i -e s:"http\://www.oasis-open.org/docbook/xml/4.1.2/docbookx.dtd":$catalogfile: src/native/unix/man/jsvc.1.xml

pushd src/native/unix
%if "%{?rhel}" == "6"
#work with docbook-xsl (from docbook-maven on rhel 6)
unzip -q %{_javadir}/docbook-xsl-resources.zip
export XSL_DIR=$XSL_DIR:`pwd`/docbook/html:`pwd`/docbook/manpages:`pwd`/docbook/common
xmlto -x docbook/manpages/docbook.xsl man man/jsvc.1.xml
%else
xmlto man man/jsvc.1.xml
%endif
popd
%endif
sed -i -e '2425s/powerpc/powerpc*/' src/native/unix/configure

zip -q -r ../%{name}-%{version}-src.zip *

%build
%if %with native
cd src/native/unix
%configure --with-java=%{java_home}
make %{?_smp_mflags}
%endif

%install
rm -rf $RPM_BUILD_ROOT
%if %with native
install -Dpm 0644 src/native/unix/jsvc.1 $RPM_BUILD_ROOT%{_mandir}/man1/jsvc.eap6.1
install -Dpm 755 src/native/unix/jsvc $RPM_BUILD_ROOT%{_bindir}/jsvc-eap6/jsvc
%endif

%if %with zip
install -d -m 755 $RPM_BUILD_ROOT%{_javadir}/jbossas-fordev
install -p -m 644 ../%{name}-%{version}-src.zip \
        $RPM_BUILD_ROOT%{_javadir}/jbossas-fordev/
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%if %with native
%files
%defattr(-,root,root,-)
%doc LICENSE*
%dir %{_bindir}/jsvc-eap6
%{_bindir}/jsvc-eap6/jsvc
%{_mandir}/man1/jsvc.eap6.1*
%endif

%if %with zip
%files src-zip
%defattr(-,root,root,-)
%{_javadir}/jbossas-fordev/*
%endif


%changelog
* Tue Apr 30 2013 Mladen Turk <mturk@redhat.com> - 1:1.0.15-3
- Fix missing 64-bit binaries

* Tue Apr 30 2013 Vaclav Tunka <vtunka@redhat.com> - 1:1.0.15-2
- Add symlinks to jakarta-commons.jar to HP-UX and Solaris platforms

* Tue Apr 16 2013 Vaclav Tunka <vtunka@redhat.com> - 1:1.0.15-1
- Upgrade to 1.0.15 for EAP 6.1.0.ER5

* Tue Apr 02 2013 Vaclav Tunka <vtunka@redhat.com> - 1:1.0.14-1
- Upgrade to 1.0.14 for EAP 6.1.0.ER4

* Mon Mar 11 2013 Vaclav Tunka <vtunka@redhat.com> - 1:1.0.13-3
- Rebuild to properly include patches

* Mon Mar 11 2013 Vaclav Tunka <vtunka@redhat.com> - 1:1.0.13-2
- Add patches: strunsafe.patch bz918199.patch

* Tue Feb 26 2013 Vaclav Tunka <vtunka@redhat.com> - 1:1.0.13-1
- Upgrade to 1.0.13 for EAP 6.1.0.ER1

* Wed Sep  5 2012 Mladen Turk <mturk@redhat.com> 1:1.0.10-9
- Rebuild.

* Tue Feb 28 2012 Mladen Turk <mturk@redhat.com> 1:1.0.10-8
- Fix new target location.

* Tue Feb 28 2012 Mladen Turk <mturk@redhat.com> 1:1.0.10-1
- Rebase to version 1.0.10.

* Wed Feb  1 2012 Mladen Turk <mturk@redhat.com> 1:1.0.8-3
- Rebuild using git repository.

* Fri Dec  9 2011 Vaclav Tunka <vtunka@redhat.com> - 1:1.0.8-2
- Rebuild for EAP 6 / EWS 2

* Tue Nov 29 2011 Mladen Turk <mturk@redhat.com> - 1:1.0.8-1
- Upgrade to 1.0.8

* Fri Oct 21 2011 Vaclav Tunka <vtunka@redhat.com> - 1:1.0.7-4
- Makefile include for general xbuild Makefile
- Moving to generated .ini file
- Add win build requires for xbuild

* Tue Oct 18 2011 Vaclav Tunka <vtunka@redhat.com> - 1:1.0.7-3
- Add fre parameter to the artifact sources
- Use local variables inside winspec file
- Remove the -win suffix
- Add dist property
- Add make win-build target to Makefile

* Wed Oct 12 2011 Vaclav Tunka <vtunka@redhat.com> - 1:1.0.7-2
- Fixed the description in the ini file
- Rebuild

* Tue Oct 11 2011 Mladen Turk <mturk@redhat.com> - 1:1.0.7-1
- Upgrade to 1.0.7

* Mon Jan 17 2011 Permaine Cheung <pcheung@redhat.com> - 1:1.0.5-1
- Upgrade to 1.0.5
- Adding missing BRs

* Tue Mar 24 2009 Permaine Cheung <pcheung@redhat.com> - 1:1.0.1-6.1
- Rebuild

* Mon Nov 03 2008 Fernando Nasser <fnasser@redhat.com> - 1:1.0.1-6
- Build without AOT

* Thu Aug 17 2006 Deepak Bhole <dbhole@redhat.com> - 1:1.0.1-6jpp.1
- Added missing requirements
- Fixed bug that cause post/postun to not run when built with --with native

* Thu Aug 10 2006 Karsten Hopp <karsten@redhat.de> 1.0.1-4jpp_3fc
- Requires(post):     coreutils

* Wed Jul 19 2006 Deepak Bhole <dbhole@redhat.com> - 1:1.0.1-4jpp_1fc
- Remove name/release/version defines as applicable.

* Mon Jul 17 2006 Deepak Bhole <dbhole@redhat.com> - 1:1.0.1-3jpp
- Added conditional native build.

* Wed Apr 12 2006 Ralph Apel <r.apel at r-apel.de> - 1:1.0.1-2jpp
- First JPP-1.7 release

* Thu Oct 27 2005 Ralph Apel <r.apel at r-apel.de> - 1:1.0.1-1jpp
- Update to 1.0.1

* Sun Aug 23 2004 Randy Watler <rwatler at finali.com> - 1:1.0-2jpp
- Rebuild with ant-1.6.2
* Tue May 18 2004 Ville Skyttä <ville.skytta at iki.fi> - 1:1.0-1jpp
- Update to 1.0.

* Sat Oct 11 2003 Ville Skyttä <ville.skytta at iki.fi> - 1:1.0-0.alpha.1jpp
- Update to 1.0 alpha, bump epoch.
- Non-versioned, crosslinked javadocs.
- Build native jsvc with "--with native".

* Thu Feb 27 2003 Henri Gomez <hgomez@users.sourceforge.net> 1.0-5jpp
- fix ASF license

* Thu Feb 27 2003 Henri Gomez <hgomez@users.sourceforge.net> 1.0-4jpp
- fix missing packager tag
- get latest nightly (20030227)
- fix ant lib location for javadoc
- added common-launcher jar

* Fri Jul 12 2002 Henri Gomez <hgomez@users.sourceforge.net> 1.0-3jpp
- clean up spec

* Mon Jun 10 2002 Henri Gomez <hgomez@users.sourceforge.net> 1.0-2jpp
- use sed instead of bash 2.x extension in link area to make spec compatible
  with distro using bash 1.1x

* Fri Jun 07 2002 Henri Gomez <hgomez@users.sourceforge.net> 1.0-1jpp 
- 1.0 (cvs 20020606)
- added short names in %{_javadir}, as does jakarta developpers
- first jPackage release
