#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#
# Run configure, make and make install for each package
# $1    package directory
# $2    destination directory
# $@

# Include common code
. "$XB_BUILD_DIR/xb.functions.sh"

postmake_exit_code=0
xb_postmake()
{
    pd="$1"
    dd="$2"
    shift; shift
    if [ ".$1" != . ]; then
        pp=true
    else
        pp=false
    fi
    if [ ! -f "$pd/package.list" ]; then
        return 22
    fi
    if [ ! -d "$dd" ]; then
        return 22
    fi
    if [ -d "$XB_BUILD_ROOT$o_prefix/$libd" ]; then
    (
        cd "$XB_BUILD_ROOT$o_prefix/$libd"
        for i in `ls -1 *.la.dist 2>/dev/null`
        do
            x=`echo $i | $XB_GSED 's;.dist$;;'`
            mv $i $x >/dev/null 2>&1 || true
        done
        for i in `ls -1 *.la 2>/dev/null`
        do
            mv $i $i.tmp >/dev/null 2>&1 || true
            $XB_GSED -e "s;$XB_BUILD_ROOT;;g" \
                     -e "s;/tmp;;g" \
                     -e "s;-L$o_prefix/lib ;-L$o_prefix/$libd ;g" \
                     $i.tmp > $i
            rm -f $i.tmp >/dev/null 2>&1 || true
            chmod 755 $i >/dev/null 2>&1 || true
        done
    )
    fi
    if [ -d "$XB_BUILD_ROOT$o_prefix/$libd/pkgconfig" ]; then
    (
        cd "$XB_BUILD_ROOT$o_prefix/$libd/pkgconfig"
        for i in `ls -1 *.pc 2>/dev/null`
        do
            mv $i $i.tmp >/dev/null 2>&1 || true
            $XB_GSED -e "s;$XB_BUILD_ROOT;;g" \
                     -e "s;/tmp;;g" \
                     -e "s;-L$o_prefix/lib ;-L$o_prefix/$libd ;g" \
                     $i.tmp > $i
            rm -f $i.tmp >/dev/null 2>&1 || true
            chmod 644 $i >/dev/null 2>&1 || true
        done
    )
    fi
    return $postmake_exit_code
}

xb_postmake $@
exit $?
