#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#

# Get platform information from uname
xb_get_platform()
{
    o_cpu=false
    o_sys=false
    o_ver=false
    o_rel=false
    o_bit=false
    o_dll=false
    o_exe=false
    o_alr=false
    o_psx=false
    o_nat=false

    o_f32=false
    o_f64=false
    if [ ".$XB_FORCE_32BIT" = ".true" ]; then
        o_f32=true
    fi
    if [ ".$XB_FORCE_64BIT" = ".true" ]; then
        o_f64=true
    fi

    d=".so"
    e=""
    v=""
    m=`(uname -m) 2>/dev/null` || m="unknown"
    s=`(uname -s) 2>/dev/null` || s="unknown"
    r=`(uname -r) 2>/dev/null` || r="unknown"
    b="32"
    c="32"
    p="unix"
    if [ $# -eq 0 ]; then
        o_all=true
    else
        o_all=false
    fi
    for o
    do
        case "$o" in
        -*=*) a=`echo "$o" | sed 's/^[-_a-zA-Z0-9]*=//'` ;;
           *) a='' ;;
        esac
        case "$o" in
            -f|--force32    ) o_f32=true;      shift ;;
            -c|--cpu        ) o_cpu=true;      shift ;;
            -s|--sys*       ) o_sys=true;      shift ;;
            -b|--bits       ) o_bit=true;      shift ;;
            -v|--ver*       ) o_ver=true;      shift ;;
            -r|--rel*       ) o_rel=true;      shift ;;
            -e|--exe        ) o_exe=true;      shift ;;
            -d|--dll        ) o_dll=true;      shift ;;
            -p|--plat*      ) o_psx=true;      shift ;;
            -n|--nat*       ) o_nat=true;      shift ;;
            -a|--all        ) o_all=true;      shift ;;
            -A|--all-rev*   ) o_alr=true;      shift ;;
            --debug)
                echo "Evaluating platform ..."
                echo "machine : $m" 
                echo "system  : $s" 
                echo "release : $r" 
                echo "32      : $o_f32" 
                echo "64      : $o_f64"
                echo ""
                return 0;
                ;;
            *  )
                echo "ERROR: Invalid command line option :\`$o'"
                return 22 
                ;;
        esac
    done
    case "$s" in
        # GNU/Linux
        Linux   )
            case "$m" in
                i[3-6]86 )  m="i386"    ;;
                *64 )       b="64"      ;;
            esac
            r=`echo "$r" |\
               sed -e 's/^\([0-9][0-9]*\.[0-9][0-9]*\).*/\1/'`
            s="linux"
            c="b"
            if $o_f32; then
                b="32"
                case "$m" in
                    ppc* )  m="ppc"   ;;
                    *64  )  m="i386"    ;;
                esac
            fi
            ;;
        SunOS   )
            case "$m" in
                i86pc )
                    m="i386"
                    case "`/bin/isainfo -k 2>&1`" in
                        amd64 )
                            m="x86_64"
                            b="64"
                            ;;
                    esac
                    ;;
                sun4[cdm] ) m="sparc"   ;;
                sun4[uv]  )
                    m="sparc64"
                    b="64"
                    ;;
                sun4*     ) m="sparc"   ;;
            esac
            r=`echo "$r" |\
               sed -e 's/^4\./1./' \
               -e 's/^5\.\([0-6]\)[^0-9]*$/2.\1/' \
               -e 's/^5\.\([0-9][0-9]*\).*/\1/'`
            s="solaris"
            c="b"
            if $o_f32; then
                b="32"
                case "$m" in
                    sparc* )  m="sparc" ;;
                    *64    )  m="i386"  ;;
                esac
            elif $o_f64; then
                b="64"
                case "$m" in
                    sparc* )  m="sparc64" ;;
                    *86    )  m="x86_64"  ;;
                esac
            fi
            ;;
        HP-UX     )
            case "$m" in
                9000/[678][0-9][0-9] )
                    m="parisc"
                    case "`/usr/bin/getconf SC_KERNEL_BITS 2>/dev/null`" in
                        32 ) b="32" ;;
                        64 )
                            b="64"
                            m="$m$b"
                            ;;
                    esac
                    ;;
                ia64 )
                    m="ia64"
                    b="64"
                    ;;
            esac
            r=`echo "$r" | sed -e 's/^[^0-9]*//'`
            s="hpux"
            d=".sl"
            c="b"
            if $o_f32; then
                b="32"
                case "$m" in
                    parisc* )  m="parisc" ;;
                    *64     )  m="i386"   ;;
                esac
            fi
            ;;
        CYGWIN_NT-[0-9].[0-9]* )
            case "x$PROCESSOR_ARCHITEW6432" in
                xIA64 )
                    m="ia64"
                    b="64"
                    ;;
                * )
                    if $o_f64; then
                        m="x86_64"
                        b="64"
                    else
                        m="i386"
                        b="32"
                    fi
                    ;;
            esac
            c="b"
            if $o_f32; then
                b="32"
                m="i386"
            fi
            d=".dll"
            e=".exe"
            r="$b"
            s="windows"
            p="windows"
            ;;
        # Windows SUA
        Interix     )
            case "$m" in
                x86 )
                    m="i386"
                    b="32"
                    ;;
                *amd )
                    m="x86_64"
                    b="64"
                    ;;
            esac
            c="b"
            if $o_f32; then
                b="32"
                m="i386"
            fi
            d=".dll"
            e=".exe"
            r="$b"
            s="windows"
            p="windows"
            ;;
        Darwin      )
            case "$m" in
                i[3-6]86 ) m="i386" ;;
                powerpc  )
                    m="ppc"
                    b="64"
                    ;;
            esac
            r=`echo "$r" |\
               sed -e 's/^\([0-9][0-9]*\.[0-9][0-9]*\).*/\1/'`
            d=".dylib"
            s="macosx"
            c="b"
            if $o_f32; then
                b="32"
            fi
            ;;
        AIX         )
            r="`uname -v`.`uname -r`"
            s="aix"
            c="b"
            m="ppc"
            if $o_f32; then
                b="32"
                m="ppc"
            elif $o_f64; then
                b="64"
                m="ppc64"
            fi
            ;;
        * )
            ;;
    esac
    v=`echo "$r" | sed -e 's/^\([0-9][0-9]*\).*/\1/'`
    if $o_alr; then
        echo "$s$v-$b $s$v-$m $s$b-$m $s-$m $s$v $s$b $s $p"
    elif $o_all; then
        echo "$p $s $s$b $s$v $s-$m $s$b-$m $s$v-$b $s$v-$m"
    else
        x=""
        if $o_sys; then
            x="$x$s"
        fi
        if $o_bit; then
            x="$x$b"
        fi
        if $o_rel; then
            x="$x$r"
        fi
        if $o_ver; then
            x="$x$v"
        fi
        if $o_cpu; then
            x="$x$m"
        fi
        if $o_dll; then
            x="$x$d"
        fi
        if $o_exe; then
            x="$x$e"
        fi
        if $o_psx; then
            x="$x$p"
        fi
        if $o_nat; then
            x="$x$n"
        fi
        echo "$x"
    fi
    return 0;
}

xb_get_platform $@
exit $?
