#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#
# Common variables used by make and build scripts
o_prefix="$XB_PACKAGE_BASE"

opts=""
if [ ".$XB_BUILD_BIT" = ".32" ]; then
    libd="lib"
    bind="bin"
    sbin="sbin"
    arch="32"
else
    libd="lib64"
    bind="bin/64"
    sbin="sbin/64"
    arch="64"
fi

if [ ".$XB_BUILD_SYS" = ".windows" ]; then
    bind="bin"
    sbin="sbin"
fi

# Common functions used by make and build scripts
xbcopypdir()
{
    install -m 755 -d "$2"
    if [ -d "$1" ]; then
    (
        cd "$1"
        $XB_GTAR -cf "$2/x.tar" .
        cd "$2"
        $XB_GTAR -xf x.tar
        rm -f x.tar 2>/dev/null || true
    )
    fi
}

xbchownmod()
{
    chmod $1 "$4" 2>/dev/null || true
    chown $2:$3 "$4" 2>/dev/null || true
}

xbmakelnk()
{
    rm -rf $2 >/dev/null 2>&1 || true
    ln -sf "$1" $2
}

xbmakedir()
{
    if [ ! -d "$1" ]; then
        mkdir -p "$1" >/dev/null 2>&1 || true
    fi
}

xbcnewdir()
{
    rm -rf "$2" >/dev/null 2>&1 || true
    (
        umask $1
        mkdir -p "$2" >/dev/null 2>&1 || true
    )
}

xbenocopy()
{
    if [ ! -f "$1" ]; then
        mv "$1.in" "$1" >/dev/null 2>&1 || true
    fi
}

xbstrtrim()
{
    echo "$1" | $XB_GSED 's/^ *//'
}

xbvaradds()
{
    if [ ".$2" = ".::" ]; then
        eval "$1=\"\""
    else
        eval e="\$$1"
        if [ ".$e" = . ]; then
            eval "$1=\"$2\""
        else
            for v in $2
            do
                xb_do_adds=true
                for i in $e
                do
                    if [ ".$v" = ".$i" ]; then
                        xb_do_adds=false
                        break
                    fi
                done
                if $xb_do_adds; then
                    e="$e $v"
                fi
            done
            eval "$1=\"$e\""
        fi
    fi
}

xbpathadd()
{
    if [ ".$2" = ".::" ]; then
        eval "$1=\"\""
    else
        eval e="\$$1"
        if [ ".$e" = . ]; then
            eval "$1=\"$2\""
        else
            for v in $2
            do
                xb_do_adds=true
                for i in $e
                do
                    if [ ".$v" = ".$i" ]; then
                        xb_do_adds=false
                        break
                    fi
                done
                if $xb_do_adds; then
                    e="$v:$e"
                fi
            done
            eval "$1=\"$e\""
        fi
    fi
}

xbfixgccflags()
{
    mx="`gcc -v --help 2>&1 | grep '\-m64'`"
    if [ ".$mx" = . ]; then
        eval e="\$$1"
        n="`echo \"$e\" | sed 's/-m64//g'`"
        n="`echo \"$n\" | sed 's/-m32//g'`"
        eval "$1=\"$n\""
    fi
}

xbexportvs()
{
    eval v="\$$1"
    if [ ".$v" != . ]; then
        export $1
    fi
}

xbstripbin()
{
    if $xb_stripdebug; then
        if $xb_verbose; then
            echo "About to strip : \`$1'"
        fi
        if [ -d "$1" ]; then
            sIFS=$IFS;
            IFS="
"
            for i in `ls -1 "$1"`
            do
                IFS=$sIFS;
                if [ -x "$1/$i" -a ! -h "$1/$i" -a ! -d "$1/$i" ]; then
                    echo "  Stripped     : \`$1/$i'"
                    chmod u+w "$1/$i" 2>/dev/null || true
                    $XB_STRIP "$1/$i" 2>/dev/null || true
                    chmod g-w "$1/$i" 2>/dev/null || true
                fi
            done
        else
            if [ -x "$1" -a ! -h "$1" ]; then
                echo "  Stripped     : \`$1'"
                chmod u+w "$1" 2>/dev/null || true
                $XB_STRIP "$1" 2>/dev/null || true
                chmod g-w "$1" 2>/dev/null || true
            fi
        fi
    fi
}

xboverride()
{
    r="$1"
    shift
    sIFS=$IFS; IFS=" "
    for o in $xb_overrider
    do
        if [ -x "$r.$o" ]; then
            r="$r.$o"
            break
        fi
        if [ -x "$r.$o.sh" ]; then
            r="$r.$o.sh"
            break
        fi
    done
    IFS=$sIFS
    if [ -x "$r.sh" ]; then
        r="$r.sh"
    fi
    if [ -x "$1.common" ]; then
        wd="`dirname \"$1.common\"`"
        wb=`basename "$1.common"`
        (
            cd "$wd"
            ./$wb $@
        )
    fi
    if [ -x "$r" ]; then
        wd="`dirname \"$r\"`"
        wb=`basename "$r"`
        (
            cd "$wd"
            ./$wb $@
        )
    fi
}

xbinstall_err=0
xbinstall()
{
    o_dir=false
    o_mod=""
    for o
    do
        case "$o" in
        -*=*) a=`echo "$o" | $XB_GSED 's/^[-_a-zA-Z0-9]*=//'` ;;
           *) a='' ;;
        esac
        case "$o" in
            -d|--dir* )
                o_dir=true
                shift
            ;;
            -m* )
                o_mod=`echo "$o" | $XB_GSED 's/-m//'`
                shift
            ;;
            *   )
                break
            ;;
        esac
    done
    xbinstall_err=22
    for o
    do
        if $o_dir; then
            d="$o"
            mkdir -p "$o" >/dev/null 2>&1 || true
            xbinstall_err=$?
        else
            d="$2"
            if [ ".$d" = . ]; then
                break;
            fi
            shift
            if [ -f "$o" ]; then
                cp -f "$o" "$d" >/dev/null 2>&1 || true
                xbinstall_err=$?
            else
                xbinstall_err=2
            fi
        fi
        if [ $xbinstall_err -ne 0 ]; then
            return
        fi
        if [ ".$o_mod" != . ]; then
            chmod $o_mod "$d"
            xbinstall_err=$?
            if [ $xbinstall_err -ne 0 ]; then
                return
            fi
        fi
    done
}

xb_fcopy()
{
    rm -f "$2" >/dev/null 2>&1 || true
    cp -p "$1" "$2" >/dev/null 2>&1 || true
    chmod 0644 "$2" >/dev/null 2>&1 || true
}

xb_toupper()
{
    echo "$1" | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
}

xb_tolower()
{
    echo "$1" | tr 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' 'abcdefghijklmnopqrstuvwxyz'
}

xb_dots2_caret()
{
    echo "$1" | tr '.' '_'
}

xb_find_gnu_tool()
{
    r=""
    t=$1
    sIFS=$IFS; IFS=": "
    for p in `echo $PATH`
    do
        if [ -x "$p/$t" ]; then
            $p/$t --help 2>/dev/null | grep -i gnu 1>/dev/null
            if [ $? -eq 0 ]; then
                r="$p/$t"
                break
            fi
        fi
    done
    IFS=$sIFS
    echo "$r"
}

xb_find_gnu_exec()
{
    r=""
    t=g$1
    sIFS=$IFS; IFS=": "
    for p in `echo $PATH`
    do
        if [ -x "$p/$t" ]; then
            r="$p/$t"
            break
        fi
    done
    IFS=$sIFS
    echo "$r"
}

xb_find_tool()
{
    r="`xb_find_gnu_tool $1`"
    if [ ".$r" = . ]; then
        e="`which $1 2>/dev/null || type $1 2>&1`"
        if [ -x "$e" ]; then
            r="$e"
        fi
    fi
    echo "$r"
}

xb_find_exec()
{
    r="`xb_find_gnu_exec $1`"
    if [ ".$r" = . ]; then
        r="`xb_find_gnu_tool $1`"
        if [ ".$r" = . ]; then
            e="`which $1 2>/dev/null || type $1 2>&1`"
            if [ -x "$e" ]; then
                r="$e"
            fi
        fi
    fi
    echo "$r"
}

xb_is_gnu_tar()
{
    if [ -n "$1" ]; then
        t="$1"
    else
        t=tar
    fi
    $t --help 2>/dev/null | grep 'owner=' 1>/dev/null
    if [ $? -eq 0 ]; then
        echo true;
    else
        echo false;
    fi
}

xb_mktmpdir()
{
    if [ -n "$1" ]; then
        tmp="$1"
    elif [ -n "$TMPDIR" ]; then
        tmp="$TMPDIR"
    elif [ -n "$TEMPDIR" ]; then
        tmp="$TEMPDIR"
    elif [ -n "$TMP" ]; then
        tmp="$TMP"
    elif [ -n "$TEMP" ]; then
        tmp="$TEMP"
    fi
    if [ ".$tmp" = . ]; then
        tmp="/tmp"
    fi
    tmp="$tmp/xbb-build-$$"
    (
        umask 077
        rm -rf "$tmp" >/dev/null 2>&1 || true
        mkdir  "$tmp" >/dev/null 2>&1
        e=$?
        if [ $e -ne 0 ]; then
            echo "ERROR: failed to create temporary directory \`$tmp'" 1>&2
            exit $e
        fi
        echo "$tmp"
    )
}

xb_realpath()
{
    (cd "`dirname \"$1\"`" 2>/dev/null && pwd)
}

xb_realdir()
{
    (cd "$1" 2>/dev/null && pwd)
}

xb_realfile()
{
    (cd "`dirname \"$1\"`" 2>/dev/null && echo "`pwd`/`basename \"$1\"`")
}

xb_rmsymjars()
{
    if [ -d "$1" ]; then
    (
        cd "$1"
        IFS="
"
        links=""
        for i in `ls -1 *.jar 2>/dev/null`
        do
            if [ -h $i ]; then
                links="$links `readlink -q $i`"
                cp $i $i.tmp >/dev/null 2>&1 || true
                mv $i.tmp $i >/dev/null 2>&1 || true
                $XB_VERBOSE "Converted symlink $i to a file"
            fi
        done
        $XB_VERBOSE "Removing symlinks $links"
        IFS=" "
        for i in $links
        do
            if [ -f $i ]; then
                rm -f $i >/dev/null 2>&1 || true
            fi
        done
    )
    fi
}

