#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#

. $XB_BUILD_DIR/xb.functions.sh
o_soversion=0

if [ -f sources ]; then
    srcd=`cat sources | head -n 1`
    if [ ".$srcd" = . ]; then
        exit 22
    fi
    ccmp=""
    bldd=`pwd`
    if [ -f makefiles.opts ]; then
        . $bldd/makefiles.opts
        opts="$GLOBAL_CFLAGS"
        for o in $XB_OVERRIDES
        do
            eval v="\$${o}_CFLAGS"
            if [ -n "$v" ]; then xbvaradds opts "$v" ; fi
            eval v="\$${o}_CC"
            if [ -n "$v" ]; then ccmp="$v"        ; fi
            eval v="\$${o}_LIBDIR"
            if [ -n "$v" ]; then libd="$v"        ; fi
            eval v="\$${o}_ARCH"
            if [ -n "$v" ]; then arch="$v"        ; fi
        done

    fi
    if [ ".$ccmp" = . ]; then
        ccmp=gcc
    fi
    if [ ".$XB_BUILD_SYS" = ".solaris" ]; then
        FIPS_SITE_LD=/usr/ccs/bin/ld
        export FIPS_SITE_LD
    fi
    if [ ".$ccmp" = ".gcc" ]; then
        xbfixgccflags CFLAGS
    fi

    RPM_OPT_FLAGS="$opts"
    xbexportvs RPM_OPT_FLAGS

    if [ -d "$srcd" ]; then
        $XB_VERBOSE "Making openssl..."
        $XB_VERBOSE "  prefix      : \`$o_prefix'"
        $XB_VERBOSE "  engines dir : \`$o_prefix/$libd/openssl/engines'"
        $XB_VERBOSE "  rpm options : $RPM_OPT_FLAGS"
        $XB_VERBOSE "  arch        : $arch-bit"
        $XB_VERBOSE ""
        if [ -f skip.makefiles ]; then
            $XB_VERBOSE "Skipping make stage"
            exit 0
        fi
        xbcnewdir 077 "$XB_BUILD_RTMP"
        cd $srcd
        if $xb_build_clean; then
            make clean
        fi

        $XB_MAKE depend
        $XB_MAKE -k all
        $XB_MAKE -k rehash

        # Install package
        $XB_MAKE -k INSTALL_PREFIX=$XB_BUILD_RTMP install_sw
        $XB_MAKE -k INSTALL_PREFIX=$XB_BUILD_RTMP install_docs
        (
            chmod 755 $XB_BUILD_RTMP$o_prefix/bin/* >/dev/null 2>&1 || true
            chmod 644 $XB_BUILD_RTMP$o_prefix/include/openssl/* >/dev/null 2>&1 || true
            chmod 755 $XB_BUILD_RTMP$o_prefix/lib/lib*.so* >/dev/null 2>&1 || true
            chmod 644 $XB_BUILD_RTMP$o_prefix/lib/lib*.a >/dev/null 2>&1 || true
            chmod 644 $XB_BUILD_RTMP$o_prefix/lib/pkgconfig/* >/dev/null 2>&1 || true
            chmod 755 $XB_BUILD_RTMP$o_prefix/lib/engines/* >/dev/null 2>&1 || true

            # Remove all fips validation files
            rm -f $XB_BUILD_RTMP$o_prefix/lib/fips* >/dev/null 2>&1 || true

            install -m 755 -d "$XB_BUILD_ROOT$o_prefix/$libd/openssl"
            mv "$XB_BUILD_RTMP$o_prefix/lib/engines" "$XB_BUILD_ROOT$o_prefix/$libd/openssl/" >/dev/null 2>&1 || true
            mv "$XB_BUILD_RTMP$o_prefix/include/openssl" "$XB_BUILD_ROOT$o_prefix/include/" >/dev/null 2>&1 || true

            cd "$XB_BUILD_ROOT$o_prefix/bin"
            if [ $XB_BUILD_BIT -eq 64 ]; then
                install -m 755 -d "$XB_BUILD_ROOT$o_prefix/bin/$arch"
                for i in `ls -1 $XB_BUILD_RTMP$o_prefix/bin`
                do
                    install -m 755 "$XB_BUILD_RTMP$o_prefix/bin/$i" "$XB_BUILD_ROOT$o_prefix/bin/$arch/$i"
                    if [ ! -f $i -a -x $arch/$i ]; then
                        xbmakelnk $arch/$i $i
                    fi
                done
                cd $arch
            else
                install -m 755 $XB_BUILD_RTMP$o_prefix/bin/* "$XB_BUILD_ROOT$o_prefix/bin"
            fi
            xbstripbin openssl$XB_EXE_EXT

            # Put manual in proper place
            for i in 1 3 5 7
            do
                cd "$XB_BUILD_RTMP$o_prefix/etc/ssl/man/man$i"
                chmod 644 *.$i >/dev/null 2>&1 || true
                $XB_GTAR cf - *.$i |\
                (   cd "$XB_BUILD_ROOT$o_prefix/man/man$i"
                    $XB_GTAR xf -
                )
            done
            xbcopypdir "$XB_BUILD_RTMP$o_prefix/lib" "$XB_BUILD_ROOT$o_prefix/$libd"
            # Fix libdir
            if [ -d "$XB_BUILD_ROOT$o_prefix/$libd/pkgconfig" ]; then
                cd "$XB_BUILD_ROOT$o_prefix/$libd/pkgconfig"
                for i in *.pc
                do
                    $XB_GSED "s;^libdir=\${exec_prefix}/lib;libdir=\${exec_prefix}/$libd;g" \
                        $i >$i.tmp
                    cat $i.tmp >$i
                    rm -f $i.tmp >/dev/null 2>&1 || true
                done
            fi
            xbstripbin "$XB_BUILD_ROOT$o_prefix/$libd/openssl/engines"

            cd "$bldd"
            # Install a makefile for generating keys and self-signed certs,
            # and a script for generating them on the fly.
            install -m 700 -d "$XB_BUILD_ROOT$o_prefix/etc/ssl/CA"
            install -m 755 -d "$XB_BUILD_ROOT$o_prefix/etc/ssl/certs"
            install -m 700 -d "$XB_BUILD_ROOT$o_prefix/etc/ssl/private"
            $XB_GSED -e "s;@@InstallBin@@;$o_prefix/$bind;g" \
                Makefile.certificate > "$XB_BUILD_ROOT$o_prefix/etc/ssl/certs/Makefile"
            $XB_GSED -e "s;@@InstallBin@@;$o_prefix/$bind;g" \
                 make-dummy-cert > "$XB_BUILD_ROOT$o_prefix/etc/ssl/certs/make-dummy-cert"

            chmod 644 "$XB_BUILD_ROOT$o_prefix/etc/ssl/certs/Makefile" >/dev/null 2>&1 || true
            chmod 755 "$XB_BUILD_ROOT$o_prefix/etc/ssl/certs/make-dummy-cert" >/dev/null 2>&1 || true
            install -m 644 "$XB_BUILD_RTMP$o_prefix/etc/ssl/openssl.cnf" "$XB_BUILD_ROOT$o_prefix/etc/ssl"
#OCSP            install -m 755 -d "$XB_BUILD_ROOT$o_prefix/doc/openssl"
#OCSP            install -m 644 OCSP.txt "$XB_BUILD_ROOT$o_prefix/doc/openssl"

            # Install root CA stuffs.
            cat << EOF > RHNS-blurb.txt
#
#  RHNS CA certificate.  Appended to the ca-bundle at package build-time.
#
EOF

            cat ca-bundle.crt RHNS-blurb.txt RHNS-CA-CERT > ca-bundle
            install -m 644 ca-bundle "$XB_BUILD_ROOT$o_prefix/etc/ssl/certs/ca-bundle.crt"
            cd "$XB_BUILD_ROOT$o_prefix/etc/ssl"
            xbmakelnk certs/ca-bundle.crt cert.pem
            # Update post install script
            cat << EOH >> $XB_BUILD_ROOT$o_prefix/etc/.postinstall
#
# $XB_BUILD_PKG OpenSSL post install script
#

setattributes 0755 root \$SUGID "$o_prefix/etc/ssl"
setattributes 0755 root \$SUGID "$o_prefix/etc/ssl/certs"
setattributes 0700 root \$SUGID "$o_prefix/etc/ssl/CA"
setattributes 0700 root \$SUGID "$o_prefix/etc/ssl/private"

EOH
        )
    else
        exit 20
    fi
else
    exit 2
fi

exit 0

