#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#

. $XB_BUILD_DIR/xb.functions.sh
o_httpdw="$XB_BUILD_ROOT/tmp"

rwip()
{
    $XB_GSED -e "s;@confdir@;$o_prefix/etc/httpd/conf;g" \
        -e "s;@logdir@;/var/log/httpd;g" \
        -e "s;@tomcatdir@;$o_prefix/var/lib/tomcat5;g" \
        -e "s;@java_home@;/opt/java;g" \
        "$1" | $XB_GREP -v "^AddModule" > "$2"
    chmod 644 "$2"
}

if [ -f sources ]; then
    srcd=`cat sources | head -n 1`
    if [ ".$srcd" = . ]; then
        exit 22
    fi
    bldd=`pwd`
    if [ -f makefiles.opts ]; then
        . $bldd/makefiles.opts
        opts="$GLOBAL_CFLAGS"
        for o in $XB_OVERRIDES
        do
            eval v="\$${o}_CFLAGS"
            if [ -n "$v" ]; then xbvaradds opts "$v" ; fi
            eval v="\$${o}_LIBDIR"
            if [ -n "$v" ]; then libd="$v"        ; fi
            eval v="\$${o}_ARCH"
            if [ -n "$v" ]; then arch="$v"        ; fi
        done
    fi

    RPM_OPT_FLAGS="$opts"
    xbexportvs RPM_OPT_FLAGS

    if [ -d "$srcd/native" ]; then
        $XB_VERBOSE "Making mod_jk..."
        $XB_VERBOSE "  prefix      : \`$o_prefix'"
        $XB_VERBOSE "  modules dir : \`$o_prefix/$libd/httpd/modules'"
        $XB_VERBOSE "  httpd dir   : \`$o_httpdw'"
        $XB_VERBOSE "  rpm options : $RPM_OPT_FLAGS"
        $XB_VERBOSE "  arch        : $arch-bit"
        $XB_VERBOSE ""
        if [ -f skip.makefiles ]; then
            $XB_VERBOSE "Skipping make stage"
            exit 0
        fi
        cd "$srcd/native"
        bldn=`pwd`
        install -m 755 -d "$XB_BUILD_ROOT$o_prefix/$libd/httpd/modules"
        install -m 755 -d "$XB_BUILD_ROOT$o_prefix/etc/httpd/conf"
        if $xb_build_clean; then
            make EXTRA_CFLAGS="$RPM_OPT_FLAGS" clean
        fi
        make EXTRA_CFLAGS="$RPM_OPT_FLAGS"
        make install
        mb="$o_httpdw$o_prefix/$libd/httpd/modules/mod_jk$XB_DLL_EXT"
        if [ ! -f "$mb" ]; then
            mb="$o_httpdw$o_prefix/$libd/httpd/modules/mod_jk.so"
        fi
        if [ -f "$mb" ]; then
            xbstripbin "$mb"
            install -m 755 "$mb" "$XB_BUILD_ROOT$o_prefix/$libd/httpd/modules/"
        else
            echo "ERROR: module not found : \`$mb'"
            exit 2
        fi
        # Install sample configuration
        cd "$bldd/$srcd/conf"
        for i in mod_jk.conf.sample mod_jk.conf.jboss.sample
        do
            rwip $i "$XB_BUILD_ROOT$o_prefix/etc/httpd/conf/$i"
        done
        mv workers.properties workers.properties.sample
        for i in workers.properties.sample workers.properties.jboss.sample
        do
            rwip $i "$XB_BUILD_ROOT$o_prefix/etc/httpd/conf/$i"
        done
        mv uriworkermap.properties uriworkermap.properties.sample
        for i in workers.properties.minimal uriworkermap.properties.sample
        do
            install -m 644 $i "$XB_BUILD_ROOT$o_prefix/etc/httpd/conf/"
        done
        # Install documentation
        cd "$bldd/$srcd"
        xbcopypdir docs "$XB_BUILD_ROOT$o_prefix/doc/mod_jk"
        # Build napi_redirect.so
        #
        if [ ".$XB_BUILD_SYS" = ".solaris" ]; then
            do_build=true
            if [ -d /opt/SUNWwbsrv70/include ]; then
                SUITSPOT_HOME=/opt/SUNWwbsrv70
            elif [ -d /opt/SUNWwbsrv61/plugins/include ]; then
                SUITSPOT_HOME=/opt/SUNWwbsrv61/plugins
            elif [ -d /opt/SUNWwbsvr/include ]; then
                SUITSPOT_HOME=/opt/SUNWwbsvr
            elif [ -d /opt/SUNWwbsvr/plugins/include ]; then
                SUITSPOT_HOME=/opt/SUNWwbsvr/plugins
            else
                do_build=false
            fi
            $XB_VERBOSE "Building NSAPI $do_build - $SUITSPOT_HOME"
            if $do_build; then
                cd "$bldn"
                make EXTRA_CFLAGS="$RPM_OPT_FLAGS" clean
                cd "$bldn/netscape"
                CFLAGS="$RPM_OPT_FLAGS $CFLAGS -O -Xa -KPIC"
                LDFLAGS="-G -KPIC -dy"
                EXTRA_LDDEFINES="-lrt -lsocket -lnsl"
                xbexportvs SUITSPOT_HOME
                xbexportvs EXTRA_LDDEFINES
                make CFLAGS="$CFLAGS" EXTRA_CFLAGS="-mt -DHAVE_CONFIG_H" LDFLAGS="$LDFLAGS"
                install -m 755 nsapi_redirector.so "$XB_BUILD_ROOT$o_prefix/$libd/"
            fi
        fi
    else
        exit 20
    fi
else
    exit 2
fi

exit 0
