# Copyright (c) 2000-2009, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

%define _jarsign_opts --nocopy

%define with()          %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()       %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
%define bcond_with()    %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}

%bcond_without repolib

%define repodir %{_javadir}/repository.jboss.com/org/jboss/native/mod-cluster/%{namedversion}-brew
%define repodirlib %{repodir}/lib
%define repodirsrc %{repodir}/src

%define reltag .GA_CP04
%define namedversion %{version}%{reltag}
%define jarname mod-cluster

Name:		mod_cluster
Summary: 	JBoss mod_cluster for Apache httpd
Version: 	1.0.10
Release: 	12.1%{reltag}%{?dist}
Epoch:		0
License: 	LGPLv3
Group: 		Applications/System
URL:		http://www.jboss.org/
# git clone git://github.com/modcluster/mod_cluster.git
# cd mod_cluster && git checkout MOD_CLUSTER_1_0_10_GA_CP04
#HEAD is now at 4eb90e2... [maven-release-plugin] prepare release MOD_CLUSTER_1_0_10_GA_CP04
# cd ../ && mv mod_cluster mod_cluster-1.0.10.GA_CP04
# tar czf mod_cluster-1.0.10.GA_CP04.tar.gz mod_cluster-1.0.10.GA_CP04
Source0:	mod_cluster-1.0.10.GA_CP04.tar.gz
Source1:        %{name}-jpp-depmap.xml
Source2:	%{name}-component-info.xml
Source3:	%{name}-upload.sh
Patch0:		mod_cluster-pom_xml.patch

BuildArch:      noarch
BuildRoot:      %{_tmppath}/%{name}-buildroot
BuildRequires:	jboss-parent
BuildRequires:	ant-junit
BuildRequires:	asm2
BuildRequires:	codehaus-stax11-api
BuildRequires:	dtdparser
BuildRequires:	glassfish-jaxb
BuildRequires:  maven2 >= 0:2.0.7-8
BuildRequires:	maven2-plugin-antrun
BuildRequires:	maven2-plugin-assembly
BuildRequires:  maven2-plugin-compiler
# To create content for maven2-brew
BuildRequires:  maven2-plugin-deploy
BuildRequires:	maven2-plugin-dependency
BuildRequires:	maven2-plugin-install
BuildRequires:	maven2-plugin-jar
BuildRequires:  maven2-plugin-resources
BuildRequires:	maven2-plugin-source
BuildRequires:	maven-release
BuildRequires:  maven-shared-invoker
BuildRequires:  maven-shared-reporting-impl
BuildRequires:	maven-surefire-maven-plugin
BuildRequires:	maven-surefire-provider-junit4
BuildRequires:	easymock2
BuildRequires:	jboss-common-logging-jdk
BuildRequires:	jboss-microcontainer2
BuildRequires:	jboss-naming
BuildRequires:	jboss-profiler
BuildRequires:	jboss-security-spi
BuildRequires:	jboss-test
BuildRequires:	jbossas
BuildRequires:  jbosssx2
BuildRequires:	jbossweb
BuildRequires:	jcip-annotations
BuildRequires:	jcommon
BuildRequires:	jfreechart
BuildRequires:	junit4
BuildRequires:	xerces-j2
BuildRequires:	jboss-cluster-ha-server-api
BuildRequires:	dtdparser
BuildRequires:	gnu-trove
BuildRequires:	jboss-serialization
BuildRequires:	zip

%description
JBoss mod_cluster for Apache httpd

%package jbossas
Summary:        Support for %{name} in JBoss AS
Group:          Development/Libraries/Application Frameworks

%description jbossas
Jar and sar files to copy to the lib directory in JBoss AS install to support use of mod_cluster

%package jbossweb2
Summary:        Support for %{name} in JBossWeb
Group:          Development/Libraries/Application Frameworks
Requires:       %{name}-jbossas = %{epoch}:%{version}-%{release}
Requires:	jboss-common-logging-jdk >= 0:2.1.2
Requires:	jboss-common-logging-spi >= 0:2.1.2

%description jbossweb2
Jar files to copy to the lib directory in JBossWeb install to support use of mod_cluster

%package tomcat6
Summary:        Support for %{name} in Tomcat6
Group:          Development/Libraries/Application Frameworks
Requires:       %{name}-jbossas = %{epoch}:%{version}-%{release}
Requires:       jboss-common-logging-jdk >= 0:2.1.2
Requires:       jboss-common-logging-spi >= 0:2.1.2

%description tomcat6
Jar files to copy to the lib directory in Tomcat install to support use of mod_cluster

%package demo
Summary:        Sample app for %{name}
Group:          Development/Frameworks
Requires:	jcommon >= 0:1.0.16
Requires:	jfreechart >= 0:1.0.13
Requires:	jakarta-commons-codec >= 0:1.3
Requires:	jakarta-commons-httpclient >= 1:3.1

%description demo
Load balancing demo application

%package zip
Summary:        %{name} full distribution
Group:          Development/Frameworks

%description zip
Full distribution; includes the jar files to support the use of mod_cluster in JBossWeb or Tomcat and a load balancing demo application. 

%package src-zip
Summary:        Container for the sources of %{name}
Group:          Development

%description src-zip
Container for the sources of %{name}

%if %with repolib
%package repolib
Summary:        Artifacts to be uploaded to a repository library
Group:          Development/Libraries/Java

%description repolib
Artifacts to be uploaded to a repository library.
This package is not meant to be installed but so its contents
can be extracted through rpm2cpio.
%endif

%prep
%setup -q -n %{name}-%{namedversion}
%patch0

%build
zip -q -r ../%{name}-%{namedversion}-src.zip *

export MAVEN_REPO_LOCAL=$(pwd)/m2_repo/repository
export CLASSPATH=$(build-classpath jbossweb/servlet-api)

mkdir external_repo
ln -s %{_javadir} external_repo/JPP

mvn-jpp -e \
        -Dmaven2.jpp.depmap.file=%{SOURCE1} \
        -Dmaven.repo.local=$MAVEN_REPO_LOCAL \
        -Dmaven.test.failure.ignore=true \
        -Dmaven2.jpp.signed \
        -Pdist package

%install
# jar
install -d -m 755 $RPM_BUILD_ROOT%{_javadir}
install -p -m 644 target/%{jarname}-%{namedversion}.jar \
           $RPM_BUILD_ROOT%{_javadir}/%{jarname}-%{version}.jar
install -p -m 644 target/%{jarname}-%{namedversion}-sources.jar \
           $RPM_BUILD_ROOT%{_javadir}/%{jarname}-%{version}-sources.jar

# pom
install -d -m 755 $RPM_BUILD_ROOT%{_datadir}/maven2/poms
install -m 644 pom.xml $RPM_BUILD_ROOT%{_datadir}/maven2/poms/JPP-%{jarname}.pom
%add_to_maven_depmap org.jboss.native %{jarname} %{namedversion} JPP %{jarname}

# sar
cp -pR target/mod-cluster.sar.dir $RPM_BUILD_ROOT%{_javadir}/%{jarname}.sar
cp -p target/%{jarname}-%{namedversion}.jar $RPM_BUILD_ROOT%{_javadir}/%{jarname}.sar/%{jarname}-%{version}.jar

(cd $RPM_BUILD_ROOT%{_javadir} && for jar in *-%{version}*; do ln -sf ${jar} ${jar/-%{version}/}; done)
(cd $RPM_BUILD_ROOT%{_javadir}/%{jarname}.sar; ln -sf %{_javadir}/%{jarname}.jar %{jarname}-%{version}.jar)

# JBossWeb / Tomcat
install -d -m 755 $RPM_BUILD_ROOT%{_datadir}/jbossweb2/lib
install -d -m 755 $RPM_BUILD_ROOT%{_datadir}/tomcat6/lib
for i in jbossweb2 tomcat6
do
pushd $RPM_BUILD_ROOT%{_datadir}/$i/lib
ln -s $(build-classpath jboss-logging-jdk)
ln -s $(build-classpath jboss-logging-spi)
ln -s %{_javadir}/mod-cluster.jar .
popd
done

# demo
install -d -m 755 $RPM_BUILD_ROOT%{_datadir}/%{name}-%{version}
rm -f target/demo/client/lib/jcommon.jar target/demo/client/lib/jfreechart.jar
build-jar-repository -s -p target/demo/client/lib \
jcommon \
jfreechart
rm -Rf target/demo/classes
(cd target/demo/server
mkdir load-demo.war.dir
pushd load-demo.war.dir
jar xf ../load-demo.war 
pushd WEB-INF/lib/
rm commons-codec.jar commons-httpclient.jar
ln -s $(build-classpath commons-codec)
ln -s $(build-classpath commons-httpclient)
popd
popd
rm load-demo.war
mv load-demo.war.dir load-demo.war)
cp -pR target/demo $RPM_BUILD_ROOT%{_datadir}/%{name}-%{version}

# docs
install -dm 755 $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
cp -p JBossORG-EULA.txt $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
cp -p lgpl.txt $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
cp -p README.txt $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
cp -p release.txt $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}

# src zip
install -dm 755 $RPM_BUILD_ROOT%{_javadir}/jbossas-fordev/
cp -pR ../%{name}-%{namedversion}-src.zip $RPM_BUILD_ROOT%{_javadir}/jbossas-fordev/

# zip
mkdir -p tmp/zip
cd tmp/zip
tar xzf ../../target/mod-cluster-%{namedversion}-bin.tar.gz
cp -pR ../../target/mod-cluster.sar.dir mod-cluster.sar
install -p -m 644 ../../target/%{jarname}-%{namedversion}.jar \
           %{jarname}.sar/%{jarname}-%{namedversion}.jar
zip -r ../../target/%{name}-%{namedversion}.zip *
cd ../../
rm -Rf target/mod-cluster-%{namedversion}-bin.tar.gz
cp -pR target/%{name}-%{namedversion}.zip $RPM_BUILD_ROOT%{_javadir}/jbossas-fordev/

rm -Rf tmp

# repolib
%if %{with_repolib}
	tag=`echo %{version}-brew`
	sed -i "s/@VERSION@/$tag/g" %{SOURCE2}
	tag=`echo %{name}-%{version}-%{release} | sed 's|\.|_|g'`
	sed -i "s/@TAG@/$tag/g" %{SOURCE2}
        install -d -m 755 $RPM_BUILD_ROOT%{repodir}
        install -d -m 755 $RPM_BUILD_ROOT%{repodirlib}
        install -m 755 %{SOURCE2} $RPM_BUILD_ROOT%{repodir}/component-info.xml
        install -d -m 755 $RPM_BUILD_ROOT%{repodirsrc}
        install -m 755 %{SOURCE0} $RPM_BUILD_ROOT%{repodirsrc}
        install -m 755 %{SOURCE1} $RPM_BUILD_ROOT%{repodirsrc}
        install -m 755 %{PATCH0} $RPM_BUILD_ROOT%{repodirsrc}
        cp -p pom.xml $RPM_BUILD_ROOT%{repodirlib}/%{jarname}.pom
        cp -p $RPM_BUILD_ROOT%{_javadir}/%{jarname}.jar $RPM_BUILD_ROOT%{repodirlib}
        cp -p $RPM_BUILD_ROOT%{_javadir}/%{jarname}-sources.jar $RPM_BUILD_ROOT%{repodirlib}
%endif

%clean
rm -Rf $RPM_BUILD_ROOT

%post jbossas
%update_maven_depmap

%postun jbossas
%update_maven_depmap

%files jbossas
%defattr(0644,root,root,0755)
%{_javadir}/%{jarname}*.jar
%{_javadir}/%{jarname}.sar
%{_datadir}/maven2/poms/*
%{_mavendepmapfragdir}/*
%doc %dir %{_docdir}/%{name}-%{version}
%doc %{_docdir}/%{name}-%{version}/JBossORG-EULA.txt
%doc %{_docdir}/%{name}-%{version}/lgpl.txt
%doc %{_docdir}/%{name}-%{version}/README.txt
%doc %{_docdir}/%{name}-%{version}/release.txt

%files jbossweb2
%defattr(0644,root,root,0755)
%{_datadir}/jbossweb2/*

%files tomcat6
%defattr(0644,root,root,0755)
%{_datadir}/tomcat6/*

%files demo
%defattr(0644,root,root,0755)
%{_datadir}/%{name}-%{version}/demo/*

%files src-zip
%defattr(0644,root,root,0755)
%{_javadir}/jbossas-fordev/%{name}-%{namedversion}-src.zip

%files zip
%defattr(0644,root,root,0755)
%{_javadir}/jbossas-fordev/%{name}-%{namedversion}.zip

%if %with repolib
%files repolib
%defattr(0644,root,root,0755)
%{_javadir}*/repository.jboss.com
%endif

%changelog
* Fri Sep 21 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-12.1.GA_CP04
- Retag (fixed version string)

* Thu Aug 23 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-10.2.GA_CP03_patch01
- Fix cve patch

* Thu Aug 02 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-10.1.GA_CP03_patch01
- Add patches to repolib

* Tue Jul 31 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-9.GA_CP03_patch01
- 1.0.10.GA_CP03 (plus all CVE and one off patches)

* Tue Mar 13 2012 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-4.1.GA_CP02_patch01
- Add patch for CVE-2012-1154

* Mon Aug 15 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-3.1.GA_CP02
- Upgrade to 1.0.10.GA_CP02

* Fri Jun 10 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-2.1.GA_CP01
- Upgrade to 1.0.10.GA_CP01

* Tue Apr 19 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-1.1
- Add version to R:

* Mon Apr 18 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-1
- Upgrade to 1.0.10.GA

* Fri Mar 18 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.9-1
- Upgrade to 1.0.9.GA

* Thu Feb 17 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.8-2
- Fix Release tag

* Wed Feb 16 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.8-1
- Upgrade to 1.0.8.GA

* Fri Jan 07 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.6-1
- Upgrade to 1.0.6.GA

* Wed Nov 24 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.5-1
- Upgrade to 1.0.5.GA

* Fri Aug 20 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.4-2.1
- Fix typo

* Wed Jul 28 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.4-1.1
- Upgrade to 1.0.4.GA
- Remove patches that are already incorporated in the tag

* Fri Jun 18 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-9.1
- Add -sources jar

* Thu May 27 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-8
- Add patches to repolib

* Tue May 25 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-7.1
- Split up mod_cluster into mod_cluster and mod_cluster-native

* Tue May 25 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-6.1
- Add patch for JBPAPP-3936, 4046, 4307
- Adjust depmap

* Mon May 17 2010 Martha Benitez <mbenitez@redhat.com> - 0:1.0.3-3.3.1
- rebuilt

* Mon Apr 19 2010 Yiqiao Wang <yiwang@redhat.com> - 0:1.0.3-3.3
- Rebuild

* Thu Apr 01 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-3.2
- Build with jars
- Revert the changes to work with httpd instead of httpd22

* Tue Feb 09 2010 Yiqiao Wang <yiwang@redhat.com> - 0:1.0.3-3.1
- Merge with RHEL-4

* Mon Jan 25 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-2.1
- Rebuild

* Mon Jan 18 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-1
- Upgrade to 1.0.3
- Merge with RHEL-4-EP-5 branch

* Fri Nov 06 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.0.2-5.1
- Do not build jars as we don't have all the dependencies on RHEL 5

* Thu Nov 05 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.0.2-5
- Fix location of zip

* Thu Nov 05 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.0.2-4
- Fix Requires:

* Thu Nov 05 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.0.2-3
- Build native .so for httpd and put them in the main package
- Rename the package that includes jars and sar for jbossas to -jbossas
- Add load-demo.war back in demo/server
- Add .so to zip
- Add src-zip

* Mon Nov 02 2009 Martha Benitez <mbenitez@redhat.com> - 0:1.0.2-2
- Add license and release notes to the main package
- Remove .dir extension from sar directory name
- Add mod_cluster.jar to sar directory
- Change sub-package names to jbossweb2 and tomcat6 to clarify versions
- Explode contents of load-demo.war inside server subdirectory in the demo sub-package

* Tue Sep 15 2009 Martha Benitez <mbenitez@redhat.com> - 0:1.0.2-1
- Brew build
- Relax version for httpd-devel
