#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#

. $XB_BUILD_DIR/xb.functions.sh

rwip()
{
    $XB_GSED -e "s;@@InstallBin@@;$o_prefix/$bind;g" \
        -e "s;@@InstallSysBin@@;$o_prefix/$sbin;g" \
        -e "s;@@InstallBase@@;$o_prefix;g" \
        "$2" > "$3"
    chmod $1 "$3"
}

if [ -f sources ]; then
    srcd=`cat sources | head -n 1`
    if [ ".$srcd" = . ]; then
        exit 22
    fi
    if [ -d "$srcd" ]; then
        $XB_VERBOSE "Making httpd prefork..."
        $XB_VERBOSE "  prefix      : \`$o_prefix'"
        $XB_VERBOSE "  libdir      : $libd"
        $XB_VERBOSE "  bindir      : $bind"
        $XB_VERBOSE "  sbindir     : $sbin"
        $XB_VERBOSE "  arch        : $arch-bit"
        $XB_VERBOSE ""
        if [ -f skip.makefiles ]; then
            $XB_VERBOSE "Skipping make stage"
            exit 0
        fi
        rpmd="`pwd`"
        xbcnewdir 077 "$XB_BUILD_RTMP"
        (
            hb="httpd.prefork"
            cd $XB_BUILD_CTMP/mpmp
            mpmd="`pwd`"
            if $xb_build_clean; then
                make clean
            fi
            make

            # Install package
            make DESTDIR=$XB_BUILD_RTMP install
            (
                cd "$XB_BUILD_RTMP$o_prefix/$libd"
                for i in `ls -1 *.la 2>/dev/null`
                do
                    mv $i $i.tmp >/dev/null 2>&1 || true
                    $XB_GSED -e "s;$XB_BUILD_ROOT;;g" \
                             -e "s;/tmp;;g" \
                             -e "s;-L$o_prefix/lib ;-L$o_prefix/$libd ;g" \
                             $i.tmp > $i
                    rm -f $i.tmp >/dev/null 2>&1 || true
                    chmod 755 $i >/dev/null 2>&1 || true
                done
            )
            # Install headers
            install -m 755 -d "$XB_BUILD_ROOT$o_prefix/include/httpd"
            cd "$XB_BUILD_RTMP$o_prefix/include/httpd"
            chmod 644 * >/dev/null 2>&1 || true
            cp apr*.h "$XB_BUILD_ROOT$o_prefix/include/httpd/" >/dev/null 2>&1 || true

            # Install libraries
            xbcopypdir "$XB_BUILD_RTMP$o_prefix/$libd" "$XB_BUILD_ROOT$o_prefix/$libd"
            cd "$XB_BUILD_ROOT$o_prefix/$libd/pkgconfig"
            for i in apr-util-1.pc
            do
                $XB_GSED "s;/.*/\(.*\).la;$o_prefix/$libd/\1.la;g" \
                    $i > $i.tmp
                    cat $i.tmp >$i
                    rm -f $i.tmp >/dev/null 2>&1 || true
            done
            # Install used libtool
            cd "$mpmd"
            install -m 755 srclib/apr/libtool "$XB_BUILD_ROOT$o_prefix/$libd/build/libtool"
            install -m 644 srclib/apr/include/arch/unix/apr_private.h "$XB_BUILD_ROOT$o_prefix/include/httpd/apr_private.h"
            # Remove unpackaged files
            rm -f $XB_BUILD_ROOT$o_prefix/$libd/*.exp >/dev/null 2>&1 || true
            # Remove Httpd modules
            rm -rf "$XB_BUILD_ROOT$o_prefix/$libd/httpd" >/dev/null 2>&1 || true
            cd "$rpmd"

            # Update post install script
            cat << EOH >> $XB_BUILD_ROOT$o_prefix/etc/.postinstall
#
# $XB_BUILD_PKG Httpd post install script
#

(
    sslcert="$o_prefix/etc/ssl/certs/localhost.crt"
    sslpkey="$o_prefix/etc/ssl/private/localhost.key"
    sserial=\$RANDOM
    if [ ".\$sserial" = . ]; then
        sserial=\$$
    fi
    umask 077
    if [ ! -f "\$sslpkey" ] ; then
        \$XBECHO "Generating private RSA key ... "
        $o_prefix/$bind/openssl genrsa -rand 1024 > "\$sslpkey" 2> /dev/null
        if [ \$? -eq 0 ]; then echo "OK" ; else echo "Failed: -\$?" ; fi
    fi
    FQDN=\`hostname\`
    if [ ".\$FQDN" = . ]; then
        FQDN=localhost.localdomain
    fi

    if [ ! -f "\$sslcert" ] ; then
        \$XBECHO "Generating new \$FQDN certificate ... "
        cat << EOF | $o_prefix/$bind/openssl req -new -key "\$sslpkey" \\
            -x509 -days 365 -set_serial \$sserial \\
            -out "\$sslcert" 2>/dev/null
--
SomeState
SomeCity
SomeOrganization
SomeOrganizationalUnit
\$FQDN
root@\$FQDN
EOF
        if [ \$? -eq 0 ]; then echo "OK" ; else echo "Failed: -\$?" ; fi
    fi
)

EOH

        )

        $XB_VERBOSE "Making httpd temp mpm ..."
        $XB_VERBOSE "  prefix      : \`$o_prefix'"
        $XB_VERBOSE "  libdir      : $libd"
        $XB_VERBOSE "  bindir      : $bind"
        $XB_VERBOSE "  sbindir     : $sbin"
        $XB_VERBOSE "  arch        : $arch-bit"
        $XB_VERBOSE ""
        (
            cd $XB_BUILD_CTMP/mpmd
            if $xb_build_clean; then
                make clean
            fi
            make
            make install
        )

    else
        exit 20
    fi

else
    exit 2
fi

exit 0

