#!/bin/sh
# Copyright(c) 2009 Red Hat Middleware, LLC,
# and individual contributors as indicated by the @authors tag.
# See the copyright.txt in the distribution for a
# full listing of individual contributors.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#

. $XB_BUILD_DIR/xb.functions.sh

if [ -f sources ]; then
    srcd=`cat sources | head -n 1`
    if [ ".$srcd" = . ]; then
        exit 22
    fi
    if [ -d "$srcd" ]; then
        $XB_VERBOSE "Making cyrus-sasl..."
        $XB_VERBOSE "  prefix      : \`$o_prefix'"
        $XB_VERBOSE "  libdir      : $libd"
        $XB_VERBOSE "  bindir      : $bind"
        $XB_VERBOSE "  sbindir     : $sbin"
        $XB_VERBOSE "  arch        : $arch-bit"
        $XB_VERBOSE ""
        if [ -f skip.makefiles ]; then
            $XB_VERBOSE "Skipping make stage"
            exit 0
        fi
        rpmd="`pwd`"
        xbcnewdir 077 "$XB_BUILD_RTMP"
        cd $srcd
        if $xb_build_clean; then
            $XB_MAKE clean
        fi
        cat saslauthd/saslauthd.mdoc > saslauthd/saslauthd.8
        $XB_MAKE sasldir=$o_prefix/$libd/sasl2

        # Install package
        $XB_MAKE DESTDIR=$XB_BUILD_RTMP sasldir=$o_prefix/$libd/sasl2 install
        chmod 755 $XB_BUILD_RTMP$o_prefix/$libd/lib*.so* >/dev/null 2>&1 || true
        chmod 755 $XB_BUILD_RTMP$o_prefix/$libd/lib*.$XB_DLL_EXT* >/dev/null 2>&1 || true
        chmod 644 $XB_BUILD_RTMP$o_prefix/$libd/lib*.a >/dev/null 2>&1 || true
        # Rename libtool files. We'll use proper names in postbuild
        for i in `ls -1 $XB_BUILD_RTMP$o_prefix/$libd/*.la 2>/dev/null`
        do
            chmod 755 $i >/dev/null 2>&1 || true
            mv $i $i.dist >/dev/null 2>&1 || true
        done

        xbcopypdir "$XB_BUILD_RTMP$o_prefix/$libd" "$XB_BUILD_ROOT$o_prefix/$libd"
        xbcopypdir "$XB_BUILD_RTMP$o_prefix/include" "$XB_BUILD_ROOT$o_prefix/include"
        cp "$XB_BUILD_RTMP$o_prefix/$sbind/saslauthd$XB_EXE_EXT" "$XB_BUILD_ROOT$o_prefix/$sbind/" >/dev/null 2>&1 || true

        # Remove plugin .la files?
        rm -f $XB_BUILD_ROOT$o_prefix/$libd/sasl2/*.la >/dev/null 2>&1 || true
        # Put manual in proper place
        for i in 3 8
        do
            if [ -d "$XB_BUILD_RTMP$o_prefix/share/man/man$i" ]; then
                m="$XB_BUILD_RTMP$o_prefix/share/man/man$i"
            else
                m="$XB_BUILD_RTMP$o_prefix/man/man$i"
            fi
            if [ -d "$m" ]; then
                cd "$m"
                chmod 644 *.$i >/dev/null 2>&1 || true
                $XB_GTAR cf - *.$i |\
                (   cd "$XB_BUILD_ROOT$o_prefix/man/man$i"
                    $XB_GTAR xf -
                )
            fi
        done

    else
        exit 20
    fi

else
    exit 2
fi

exit 0

