#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#

# Include common code
. "`dirname $0`/xb.common.sh"
. "`dirname $0`/xb.functions.sh"

# Parse command line options
$XB_VERBOSE ""
$XB_VERBOSE "Running       : $xb_prognam"
$XB_VERBOSE ""
$XB_VERBOSE "Started       : `date`"
$XB_VERBOSE "Params        : $@"
$XB_VERBOSE ""

XB_FORCE_32BIT=false
XB_FORCE_64BIT=false
XB_FORCE_ISSET=false
XB_BUILD_PKG=""
o_ver=false
xb_build_bzip=false
xb_build_sources=true
xb_build_bindist=false
xb_build_bintest=false
xb_stripdebug=false
xb_stripasect=false

xb_build_owner="root"
xb_build_group="bin"
xb_build_suser=false
xb_build_clear=false
xb_build_clean=false
xb_build_nkeep=false
xb_build_force=false
xb_build_dists=true
xb_bskip_nused=true
xb_build_devel=false
xb_build_clist=false

for o
do
    case "$o" in
    -*=*) a=`echo "$o" | sed 's/^[-_a-zA-Z0-9]*=//'` ;;
       *) a='' ;;
    esac
    case "$o" in
        -v|--vers*  )
            o_ver=true
            shift
            ;;
        -r|--strip-a*   )
            xb_stripdebug=true
            shift
            ;;
        -R|--strip-d*   )
            xb_stripdebug=true
            xb_stripasect=true
            shift
            ;;
        -V|--verb*  )
            xb_verbose=true
            xb_setup_verbose
            shift
            ;;
        -32|-m32     )
            XB_FORCE_32BIT=true
            XB_FORCE_64BIT=false
            shift
            ;;
        -64|-m64     )
            XB_FORCE_32BIT=false
            XB_FORCE_64BIT=true
            shift
            ;;
        -j|--bzip*   )
            xb_build_bzip=true
            shift
            ;;
        -b|--bin*    )
            xb_build_bindist=true
            shift
            ;;
        -t|--test    )
            xb_build_bintest=true
            shift
            ;;
        --package=*  )
            XB_BUILD_PKG=$a;
            shift
            ;;
        --owner=*    )
            xb_build_owner=$a;
            xb_build_suser=true
            shift
            ;;
        --group=*    )
            xb_build_group=$a;
            xb_build_suser=true
            shift
            ;;
        -S|--set-ow* )
            xb_build_suser=true
            shift
            ;;
        -c|--clean   )
            xb_build_clean=true
            shift
            ;;
        -f|--force   )
            xb_build_force=true
            shift
            ;;
        -C|--clear   )
            xb_build_clear=true
            shift
            ;;
        -K|--no-keep )
            xb_build_nkeep=true
            shift
            ;;
        -D|--no-dist )
            xb_build_dists=false
            shift
            ;;
        -U|--build-unused )
            xb_bskip_nused=false
            shift
            ;;
        -d|--devel )
            xb_build_devel=true
            shift
            ;;
        -L|--component-list    )
            xb_build_clist=true
            shift
            ;;
        *  )
            break
            ;;
    esac
done

XB_OPT_CCV="gcc --version"
XB_OPT_CC=""
XB_OPT_CPP=""
XB_OPT_CFLAGS=""
XB_PPATH=""
XB_LPATH=""
XB_NPATH=""

export XB_FORCE_32BIT
export XB_FORCE_64BIT
export xb_build_suser
export xb_build_owner
export xb_build_group
export xb_build_nkeep
export xb_build_dists
export xb_build_devel
export xb_build_clean
export xb_build_clear
export xb_build_clist
export xb_build_force
export xb_bskip_nused

$XB_VERBOSE "`$xb_progloc/xb.platform.sh --debug`"
xb_overrides="`$xb_progloc/xb.platform.sh --all`"
xb_overrider="`$xb_progloc/xb.platform.sh --all-reverse`"
XB_OVERRIDER="`xb_toupper \"$xb_overrider\" | sed 's/-/_/g'`"
XB_OVERRIDES="`xb_toupper \"$xb_overrides\" | sed 's/-/_/g'`"
s=`$xb_progloc/xb.platform.sh --system`
c=`$xb_progloc/xb.platform.sh --cpu`

if [ ".$s" = .solaris ]
then
    test ".$c" = .sparc64 && XB_SARCH=/sparcv9
    test ".$c" = .x86_64  && XB_SARCH=/amd64
    export XB_SARCH
fi

for o in $XB_OVERRIDER
do
    if [ -f "$xb_progloc/defs/$o.def" ]; then
        . "$xb_progloc/defs/$o.def"
    fi
done
if [ -n "$XB_PPATH" ]; then
    $XB_VERBOSE "Changing..."
    $XB_VERBOSE "  PATH            : \`$PATH'"
    $XB_VERBOSE "  To"
    $XB_VERBOSE "  PATH            : \`$XB_PPATH'"
    $XB_VERBOSE ""
    PATH="$XB_PPATH"
    export PATH
fi
if [ -n "$XB_NPATH" ]; then
    $XB_VERBOSE "Changing..."
    $XB_VERBOSE "  PATH            : \`$PATH'"
    $XB_VERBOSE "  To"
    PATH="$XB_NPATH:$PATH"
    $XB_VERBOSE "  PATH            : \`$PATH'"
    $XB_VERBOSE ""
    export PATH
fi

if [ -n "$XB_LPATH" ]; then
    if [ ".$XB_LPATH" = ".null" ]; then
        XB_LPATH=""
    else
        if [ ".`uname -o 2>/dev/null`" = ".Cygwin" ]; then
            PATH="$XB_LPATH:$PATH"
            export PATH
        fi
    fi
    $XB_VERBOSE "Changing..."
    $XB_VERBOSE "  LD_LIBRARY_PATH : \`$LD_LIBRARY_PATH'"
    $XB_VERBOSE "  To"
    $XB_VERBOSE "  LD_LIBRARY_PATH : \`$XB_LPATH'"
    $XB_VERBOSE ""
    LD_LIBRARY_PATH="$XB_LPATH"
    export LD_LIBRARY_PATH
fi


# Export some required binaries
XB_GTAR="`xb_find_exec tar`"
XB_GSED="`xb_find_exec sed`"
XB_GZIP="`xb_find_tool gzip`"
XB_GREP="`xb_find_tool grep`"
XB_MAKE="`xb_find_tool make`"
XBPATCH="`xb_find_tool patch`"
PERL="`which perl 2>/dev/null`"
PYTHON="`which python 2>/dev/null`"
RANLIB="`which ranlib 2>/dev/null`"
UNIX2DOS="`which unix2dos 2>/dev/null`"
$XB_GTAR --help 2>/dev/null | $XB_GREP 'no-same-owner' 1>/dev/null
if [ $? -eq 0 ]; then
    XB_TARXOPTS="--no-same-owner -xf"
else
    XB_TARXOPTS="xof"
fi
$XB_GTAR --help 2>/dev/null | $XB_GREP 'no-same-owner' 1>/dev/null
if [ $? -eq 0 ]; then
    XB_TARLZMA=true
else
    XB_TARLZMA=false
fi
export XB_GTAR
export XB_GZIP
export XB_GSED
export XB_GREP
export XB_MAKE
export XBPATCH
export RANLIB
export PERL
export PYTHON
export UNIX2DOS
export XB_TARXOPTS
export XB_TARLZMA

# Try to locate a MD5 binary
md5_bin="`which md5sum 2>/dev/null || type md5sum 2>&1`"
if [ ! -x "$md5_bin" ]; then
    md5_bin="`which md5 2>/dev/null || type md5 2>&1`"
fi
if [ ! -x "$md5_bin" ]; then
    md5_bin="`which digest 2>/dev/null || type digest 2>&1`"
fi
if [ -x "$md5_bin" ]; then
    md5_arg=""
    if [ "`basename $md5_bin 2>/dev/null`" = digest ]; then
        md5_arg=" -a md5"
    fi
    MD5SUM="$md5_bin$md5_arg"
else
    MD5SUM="echo 00000000000000000000000000000000 "
fi
export MD5SUM

XB_BZIP="`which bzip2 2>/dev/null || type bzip2 2>&1`"
if [ ! -x "$XB_BZIP" ]; then
    XB_BZIP=""
fi
export XB_BZIP

XB_STRIP="`which strip 2>/dev/null || type strip 2>&1`"
if [ ! -x "$XB_STRIP" ]; then
    xb_stripdebug=false
else
    if $xb_stripasect; then
        $XB_STRIP --help 2>/dev/null | $XB_GREP '\-S' 1>/dev/null
        if [ $? -eq 0 ]; then
            XB_STRIP="$XB_STRIP -S"
        else
            XB_STRIP="$XB_STRIP -x"
        fi
    fi
fi
export xb_stripdebug

$XB_VERBOSE ""
$XB_VERBOSE "Using tools...."
$XB_VERBOSE ""
$XB_VERBOSE "  tar         : \`$XB_GTAR'"
$XB_VERBOSE "  gzip        : \`$XB_GZIP'"
$XB_VERBOSE "  bzip2       : \`$XB_BZIP'"
$XB_VERBOSE "  gsed        : \`$XB_GSED'"
$XB_VERBOSE "  grep        : \`$XB_GREP'"
$XB_VERBOSE "  make        : \`$XB_MAKE'"
$XB_VERBOSE "  patch       : \`$XBPATCH'"
$XB_VERBOSE "  perl        : \`$PERL'"
$XB_VERBOSE "  python      : \`$PYTHON'"
$XB_VERBOSE "  unix2dos    : \`$UNIX2DOS'"
$XB_VERBOSE "  ranlib      : \`$RANLIB'"
$XB_VERBOSE "  md5sum      : \`$MD5SUM'"
$XB_VERBOSE ""

XB_BUILD_SYS=${XB_BUILD_SYS:=`$xb_progloc/xb.platform.sh --system`}
XB_BUILD_VER=${XB_BUILD_VER:=`$xb_progloc/xb.platform.sh --version`}
XB_BUILD_CPU=${XB_BUILD_CPU:=`$xb_progloc/xb.platform.sh --cpu`}
XB_BUILD_BIT=${XB_BUILD_BIT:=`$xb_progloc/xb.platform.sh --bits`}
XB_BUILD_NCA=${XB_BUILD_BIT:=`$xb_progloc/xb.platform.sh --native`}
XB_BUILD_REL=${XB_BUILD_REL:=`$xb_progloc/xb.platform.sh --release`}

export xb_overrides
export xb_overrider
export XB_OVERRIDES
export XB_OVERRIDER
export XB_BUILD_SYS
export XB_BUILD_VER
export XB_BUILD_CPU
export XB_BUILD_BIT
export XB_BUILD_NCA
export XB_BUILD_REL

XB_DLL_EXT=${XB_DLL_EXT:=`$xb_progloc/xb.platform.sh --dll`}
XB_EXE_EXT=${XB_EXE_EXT:=`$xb_progloc/xb.platform.sh --exe`}
export XB_DLL_EXT
export XB_EXE_EXT

if [ $XB_BUILD_BIT -ne $XB_BUILD_NCA ]; then
    XB_FORCE_ISSET=true
fi
export XB_FORCE_ISSET

# Export platform definitions
export XB_OPT_CC
export XB_OPT_CPP
export XB_OPT_CCV
export XB_OPT_CFLAGS
if [ ".$JAVA_HOME" = . ]; then
    echo "ERROR: Missing JAVA_HOME environment variable"
    xb_exit 2
fi

if [ -x "$xb_progloc/setup.sh" ]; then
    $xb_progloc/setup.sh $@
    build_exit_code=$?
    if [ $build_exit_code -ne 0 ]; then
        echo "ERROR: setup failed with exit code: $build_exit_code"
        xb_exit $build_exit_code
    fi
fi

if [ ! -x "$xb_progloc/build.sources.sh" ]; then
    xb_build_sources=false
fi
if [ -f "$xb_progloc/build.package" ]; then
    XB_BUILD_PKG=`$XB_GSED -e 's/^[[:blank:]]*//' \
        -e '/^[[:blank:]]*$/d' \
        -e '/^[#;].*/d' \
        $xb_progloc/build.package | head -n 1`
    xb_build_sources=false
    if $xb_build_bintest; then
        xb_build_bindist=false
    else
        xb_build_bindist=true
    fi
elif [ ".$XB_BUILD_PKG" = . ]; then
    XB_BUILD_PKG="$1"
fi
if [ ".$XB_BUILD_PKG" = . ]; then
    echo "ERROR: undefined build package"
    xb_exit 22
fi
export XB_BUILD_PKG
# Local variables
build_exit_code=0

# Export global definitions
. "`dirname $0`/defs/COMMON.def"
export XB_REDHAT_CVS_DDIR
export XB_REDHAT_CVS_REPO
export XB_FEDORA_CVS_DDIR
export XB_FEDORA_CVS_REPO
export XB_REDHAT_GIT_DDIR
export XB_REDHAT_GIT_REPO
export XB_REPOSITORY_SURL
export XB_REDHAT_BREW_URL
export XB_JBOSS_ANONSVN_URL
export XB_VERSION
export XB_REVISION
export xb_build_bzip
export XB_STRIP

# Check the repository location
xb_use_local_repository=false
XB_REPOSITORY_PATH=""
if $xb_build_sources; then
    if [ -d "$xb_progloc/$XB_REPOSITORY_RDIR" ]; then
        xb_use_local_repository=true
        XB_REPOSITORY_PATH="`xb_realdir \"$xb_progloc/$XB_REPOSITORY_RDIR\"`"
        $XB_VERBOSE "Using local repository : \`$XB_REPOSITORY_PATH'"
    else
        $XB_VERBOSE "Using remote repository: \`$XB_REPOSITORY_SURL'"
    fi
fi
export XB_REPOSITORY_PATH


# Create temporary build directory
XB_BUILD_TMP=`xb_mktmpdir`
xb_at_exit --delete $XB_BUILD_TMP

XB_BUILD_DIR=${XB_BUILD_DIR:="$xb_progloc"}
if $xb_build_sources; then
    XB_BUILD_TOP=${XB_BUILD_TOP:=`xb_realdir "$xb_progloc/../"`}
else
    XB_BUILD_TOP="$XB_BUILD_DIR"
fi
XB_WINUEXECC="$XB_BUILD_DIR/xtool.exe exec -c"
XB_WINMKLINK="$XB_BUILD_DIR/xtool.exe mklink"

export XB_BUILD_TMP
export XB_BUILD_TOP
export XB_BUILD_DIR
export XB_WINUEXECC
export XB_WINMKLINK

# Create directories
if [ ! -f "$XB_BUILD_TOP/$XB_BUILD_PKG/package.spec" ]; then
    echo "ERROR: cannot find package spec file \`$XB_BUILD_TOP/$XB_BUILD_PKG/package.spec'"
    xb_exit 2
fi
if [ ! -f "$XB_BUILD_TOP/$XB_BUILD_PKG/package.list" ]; then
    echo "ERROR: cannot find package list file \`$XB_BUILD_TOP/$XB_BUILD_PKG/package.list'"
    xb_exit 2
fi

# Read the package specification
. "$XB_BUILD_TOP/$XB_BUILD_PKG/package.spec"

export XB_PACKAGE_PKG
export XB_PACKAGE_PPKG
export XB_PACKAGE_NAME
export XB_PACKAGE_CATEGORY
export XB_PACKAGE_DESC
export XB_PACKAGE_VENDOR
export XB_PACKAGE_EMAIL
export XB_PACKAGE_MAJOR
export XB_PACKAGE_MINOR
export XB_PACKAGE_MICRO
export XB_PACKAGE_VERSION
export XB_PACKAGE_REV
export XB_PACKAGE_ROOT
export XB_PACKAGE_DEST
export XB_PACKAGE_RWIN
export XB_PACKAGE_BWIN
export XB_PACKAGE_CWIN
export XB_PACKAGE_UNAM
export XB_PACKAGE_WNAM
export XB_PACKAGE_PATCH
export XB_PACKAGE_NATIVE

XB_PACKAGE_BASE="/$XB_PACKAGE_ROOT/$XB_PACKAGE_DEST"
export XB_PACKAGE_BASE

XB_PACKAGE_DISTNAME="$XB_PACKAGE_PKG-$XB_PACKAGE_VERSION"
if [ -n "$XB_PACKAGE_REV" ]; then
    XB_PACKAGE_DISTNAME="${XB_PACKAGE_DISTNAME}_${XB_PACKAGE_REV}"
fi
export XB_PACKAGE_DISTNAME
XB_PACKAGE_DISTPATCH="$XB_PACKAGE_PKG-$XB_PACKAGE_VERSION"
if [ -n "$XB_PACKAGE_PATCH" ]; then
    XB_PACKAGE_DISTPATCH="${XB_PACKAGE_DISTPATCH}_${XB_PACKAGE_PATCH}"
fi
export XB_PACKAGE_DISTPATCH

if $xb_build_sources; then
    XB_BUILD_BASE=${XB_BUILD_BASE:="$XB_BUILD_DIR/$XB_PACKAGE_DISTNAME"}
else
    XB_BUILD_BASE="$XB_BUILD_DIR"
fi
XB_BUILD_ROOT="$XB_BUILD_BASE/root"
XB_BUILD_DIST="$XB_BUILD_BASE/dist"
XB_BUILD_PDIR="$XB_BUILD_BASE/$XB_PACKAGE_PKG"
XB_BUILD_TDIR="$XB_BUILD_BASE/temp"
export XB_BUILD_BASE
export XB_BUILD_ROOT
export XB_BUILD_DIST
export XB_BUILD_PDIR
export XB_BUILD_TDIR

if [ ".`echo \".$1\" | $XB_GREP \"^.$XB_BUILD_PKG\"`" != "." ]; then
    shift
elif [ ".`echo \".$1\" | $XB_GREP \"^.RHAT\"`" != "." ]; then
    shift
fi

$XB_VERBOSE ""
$XB_VERBOSE "System        : $XB_BUILD_SYS"
$XB_VERBOSE "Version       : $XB_BUILD_VER"
$XB_VERBOSE "Release       : $XB_BUILD_REL"
$XB_VERBOSE "Platform      : $XB_BUILD_CPU"
$XB_VERBOSE "Architecture  : $XB_BUILD_BIT"
$XB_VERBOSE "Force 32-bit  : $XB_FORCE_32BIT"
$XB_VERBOSE "      64-bit  : $XB_FORCE_64BIT"
$XB_VERBOSE "      forced  : $XB_FORCE_ISSET"
$XB_VERBOSE "Host          : `whoami`@`hostname`"
$XB_VERBOSE ""
$XB_VERBOSE "Temporary dir : $XB_BUILD_TMP"
$XB_VERBOSE "Build top     : $XB_BUILD_TOP"
$XB_VERBOSE "Build dir     : $XB_BUILD_DIR"
$XB_VERBOSE "Package build : $XB_BUILD_PKG"
$XB_VERBOSE "Build base    : $XB_BUILD_BASE"
$XB_VERBOSE "Build package : $XB_BUILD_PDIR"
$XB_VERBOSE "Build root    : $XB_BUILD_ROOT"
$XB_VERBOSE "Build dist    : $XB_BUILD_DIST"
$XB_VERBOSE ""
$XB_VERBOSE "Package       : $XB_PACKAGE_PPKG"
$XB_VERBOSE "Package name  : $XB_PACKAGE_NAME"
$XB_VERBOSE "Package ver   : $XB_PACKAGE_VERSION"
$XB_VERBOSE "Package rev   : $XB_PACKAGE_REV"
$XB_VERBOSE "Package dist  : $XB_PACKAGE_DISTNAME"
$XB_VERBOSE ""
$XB_VERBOSE "Script args   : $@"

if $o_ver; then
    echo "XBuild version: $XB_VERSION-$XB_REVISION"
    xb_exit 0
fi

if [ ".$XB_BUILD_SYS" = ".windows" ]; then
    xb_build_suser=false
    export xb_build_suser
    XB_TARXOPTS="-xf"
    export XB_TARXOPTS
    CYGWIN_ROOT="`cygpath --windows / 2>/dev/null`"
    export CYGWIN_ROOT
fi

# Execute setup overrides
overridden=false
for o in $xb_overrider
do
    if [ -x "$xb_progloc/xbs.setup-$o.sh" ]; then
        $xb_progloc/setup-$o.sh $@
        build_exit_code=$?
        if [ $build_exit_code -ne 0 ]; then
            echo "ERROR: setup-$o failed with exit code: $build_exit_code"
            xb_exit $build_exit_code
        fi
        overridden=true
        break
    fi
done

if $xb_build_sources; then
    $xb_progloc/build.sources.sh $@
    build_exit_code=$?
    if [ $build_exit_code -ne 0 ]; then
        echo "ERROR: build sources failed with exit code: $build_exit_code"
        xb_exit $build_exit_code
    fi
fi

if $xb_build_bindist; then
    $xb_progloc/build.bindist.sh $@
    build_exit_code=$?
    if [ $build_exit_code -ne 0 ]; then
        echo "ERROR: build binaries failed with exit code: $build_exit_code"
        xb_exit $build_exit_code
    fi
fi

if $xb_build_bintest; then
    $xb_progloc/build.bintest.sh $@
    build_exit_code=$?
    if [ $build_exit_code -ne 0 ]; then
        echo "ERROR: test binaries failed with exit code: $build_exit_code"
        xb_exit $build_exit_code
    fi
fi

xb_exit $build_exit_code

