#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#

# Include common code
. "$XB_BUILD_DIR/xb.common.sh"
. "$XB_BUILD_DIR/xb.functions.sh"

build_bintest()
{
    XB_UMOUNT="`which umount 2>/dev/null || type umount 2>&1`"
    if [ ! -x "$XB_UMOUNT" ]; then
        if [ -x /usr/sbin/umount ]; then
            XB_UMOUNT="/usr/sbin/umount"
        else
            echo "Cannot find umount command ..."
            return 22
        fi
    fi
    XB_CHROOT="`which chroot 2>/dev/null || type chroot 2>&1`"
    if [ ! -x "$XB_CHROOT" ]; then
        if [ -x /usr/sbin/chroot ]; then
            XB_CHROOT="/usr/sbin/chroot"
        else
            echo "Cannot find chroot command ..."
            return 22
        fi
    fi

    sudo rm -rf "$XB_BUILD_ROOT/tmp" >/dev/null 2>&1 || true
    echo ""
    echo "Making chroot : \`$XB_BUILD_ROOT'"

    $XB_BUILD_DIR/xb.chrootmake.sh "$XB_BUILD_ROOT"

    cat << EOF > "$XB_BUILD_ROOT/tmp/run.tests"
#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# $XB_BUILD_PKG Test script
#

echo ""
echo "Running tests for \\\`$XB_BUILD_PKG' ..."
echo ""

env

EOF
    if [ ".$XB_BUILD_SYS" = ".solaris" ]; then
        cat << EOF >> "$XB_BUILD_ROOT/tmp/run.tests"
# Setup the solaris environment
LD_LIBRARY_PATH_32=$XB_PACKAGE_BASE/lib:/lib:/usr/lib
LD_LIBRARY_PATH_64=$XB_PACKAGE_BASE/lib64/lib/64:/usr/lib/64
export LD_LIBRARY_PATH_32
export LD_LIBRARY_PATH_64

EOF
    else
        cat << EOF >> "$XB_BUILD_ROOT/tmp/run.tests"
# Setup the environment
LD_LIBRARY_PATH=/lib:/usr/lib
export LD_LIBRARY_PATH
if [ -d $XB_PACKAGE_BASE/lib64 ]; then
    LD_LIBRARY_PATH=$XB_PACKAGE_BASE/lib64:/lib64:/usr/lib64:\$LD_LIBRARY_PATH
else
    LD_LIBRARY_PATH=$XB_PACKAGE_BASE/lib:\$LD_LIBRARY_PATH
fi
export LD_LIBRARY_PATH

EOF
    fi
    cat << EOF >> "$XB_BUILD_ROOT/tmp/run.tests"
# Running post install script
cat << EOS >/tmp/TESTS.txt
-----------------------------------------------------------------------
Executing postinstall script \\\`$XB_PACKAGE_BASE/etc/.postinstall'
-----------------------------------------------------------------------

EOS
$XB_PACKAGE_BASE/etc/.postinstall >>/tmp/TESTS.txt

EOF

    sIFS=$IFS; IFS=$XB_LF
    lines=`$XB_GSED -e 's/^[[:blank:]]*//' \
            -e '/^[[:blank:]]*$/d' \
            -e '/^[#;].*/d' "$XB_BUILD_TOP/$XB_BUILD_PKG/package.list"`
    for l in $lines
    do
        IFS=$sIFS
        r=`echo $l | awk '{print $1}'`
        n=`echo $l | awk '{print $2}'`
        if [ ".$r" = . ]; then
            continue
        fi
        if [ -f "$XB_BUILD_TOP/$XB_BUILD_PKG/$n/$n.test" ]; then
            cp -f "$XB_BUILD_TOP/$XB_BUILD_PKG/$n/$n.test" "$XB_BUILD_ROOT/tmp/" >/dev/null 2>&1 || true
            cat << EOF >> "$XB_BUILD_ROOT/tmp/run.tests"

# $r test
sh /tmp/$n.test

EOF
        fi
    done
    cat << EOF >> "$XB_BUILD_ROOT/tmp/run.tests"
# End of test
exit 0

EOF
    chmod 755 "$XB_BUILD_ROOT/tmp/run.tests"
    sudo $XB_CHROOT "$XB_BUILD_ROOT" /tmp/run.tests
    if [ -f "$XB_BUILD_ROOT/tmp/TESTS.txt" ]; then    
        cp "$XB_BUILD_ROOT/tmp/TESTS.txt" "$XB_DAEMON_ARTIFACTS_DIR/tst/"
    else
    cat << EOF > "$XB_DAEMON_ARTIFACTS_DIR/tst/TESTS.txt"
-----------------------------------------------------------------------
Test execution failed
-----------------------------------------------------------------------

EOF

    fi
    echo "Removing chrooted environment ..."
    sudo $XB_UMOUNT "$XB_BUILD_ROOT/proc" >/dev/null 2>&1 || true
    sudo -b rm -rf "$XB_BUILD_ROOT" >/dev/null 2>&1 || true
    return 0
}

build_bintest $@
exit $?
