#!/bin/sh
# Copyright(c) 2012 Red Hat, Inc.
#
# This is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This sofware is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#

# Include common code
. "$XB_BUILD_DIR/xb.common.sh"
. "$XB_BUILD_DIR/xb.functions.sh"

build_bindist()
{
    XB_BUILD_RTMP="$XB_BUILD_TMP/.bin"
    # Create temporary root package directory
    xbcnewdir 077 "$XB_BUILD_RTMP"
    if [ ! -d "$XB_BUILD_RTMP" ]; then
        echo "ERROR: failed creating temp: \`$td'"
        return 13
    fi
    export XB_BUILD_RTMP
    XB_BUILD_CTMP="$XB_BUILD_TMP/.cfg"
    # Create temporary root package directory
    xbcnewdir 077 "$XB_BUILD_CTMP"
    if [ ! -d "$XB_BUILD_CTMP" ]; then
        echo "ERROR: failed creating temp: \`$td'"
        return 13
    fi
    export XB_BUILD_CTMP
    if [ ! -d "$XB_BUILD_ROOT" ]; then
        echo "ERROR: missing root base: \`$XB_BUILD_ROOT'"
        return 13
    fi
    if $xb_build_suser; then
        rmcmd="sudo rm -rf"
    else
        rmcmd="rm -rf"
    fi
    if $xb_build_clear; then
        eval "$rmcmd \"$XB_BUILD_ROOT/opt\" >/dev/null 2>&1 || true"
        eval "$rmcmd \"$XB_BUILD_ROOT/tmp\" >/dev/null 2>&1 || true"
    fi

    # Create directories
    install -m 755 -d "$XB_BUILD_ROOT$XB_PACKAGE_BASE"
    for i in bin doc etc include sbin share var
    do
        install -m 755 -d "$XB_BUILD_ROOT$XB_PACKAGE_BASE/$i"
    done
    if [ $XB_BUILD_SYS = windows ]; then
        if [ $XB_BUILD_BIT -eq 64 ]; then
            install -m 755 -d "$XB_BUILD_ROOT$XB_PACKAGE_BASE/lib64"
            libd="lib64"
        else
            install -m 755 -d "$XB_BUILD_ROOT$XB_PACKAGE_BASE/lib"
            libd="lib"
        fi
    else
        if [ $XB_BUILD_BIT -eq 64 ]; then
            install -m 755 -d "$XB_BUILD_ROOT$XB_PACKAGE_BASE/bin/64"
            install -m 755 -d "$XB_BUILD_ROOT$XB_PACKAGE_BASE/sbin/64"
            install -m 755 -d "$XB_BUILD_ROOT$XB_PACKAGE_BASE/lib64"
            # Relink lib -> lib64
            (
                rm -rf "$XB_BUILD_ROOT$XB_PACKAGE_BASE/lib" >/dev/null 2>&1
                cd "$XB_BUILD_ROOT$XB_PACKAGE_BASE"
                ln -s lib64 lib
            )
            libd="lib64"
            crlo="-64 -l"
        else
            # Remove any 64-bit links to lib
            if [ -h "$XB_BUILD_ROOT$XB_PACKAGE_BASE/lib" ]; then
                rm -rf "$XB_BUILD_ROOT$XB_PACKAGE_BASE/lib" >/dev/null 2>&1
            fi
            install -m 755 -d "$XB_BUILD_ROOT$XB_PACKAGE_BASE/lib"
            libd="lib"
            crlo="-l"
        fi
    fi
    for i in 1 2 3 4 5 6 7 8
    do
        install -m 755 -d "$XB_BUILD_ROOT$XB_PACKAGE_BASE/man/man$i"
    done
    cat << EOF > "$XB_BUILD_ROOT$XB_PACKAGE_BASE/etc/.postinstall"
#!/bin/sh
# Copyright(c) 2011 Red Hat, Inc.
#
# This is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This software is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# $XB_BUILD_PKG Post install script
#
if [ -d /usr/xpg4/bin ]; then
    PATH=/usr/xpg4/bin:\$PATH
    export PATH
fi

if type printf > /dev/null; then
    XBECHO="printf"
elif [ -x /usr/ucb/echo ]; then
    XBECHO="/usr/ucb/echo -n"
else
    XBECHO="echo"
fi

if [ ".\`id -nu\`" = .root ]; then
    SUGID=root
else
    "This script must bust be run as superuser" >&2
    exit 1
fi

check_java_home="no"

setattributes()
{
    chmod \$1 "\$4" 2>/dev/null || true
    chown \$2:\$3 "\$4" 2>/dev/null || true
}

dirattributes()
{
    if [ -d "\$4" ]; then
        chmod \$1 "\$4" 2>/dev/null || true
        chown -R \$2:\$3 "\$4" 2>/dev/null || true
        (
            cd "\$4"
            find . -type d -exec chmod \$1 '{}' \;
        )
    fi
}

createsymlink()
{
    rm -rf \$2 >/dev/null 2>&1 || true
    ln -sf "\$1" \$2
}

createbasedir()
{
    if [ ! -d "\$1" ]; then
        mkdir -p "\$1"
        if [ \$? -ne 0 ]; then
            exit \$?
        fi
    fi
}

copynoreplace()
{
    if [ ! -f "\$1" ]; then
        mv "\$1.in" "\$1" >/dev/null 2>&1 || true
    else
        rm -f "\$1.in" >/dev/null 2>&1 || true
    fi
}

#
# Fix directory permissions
#
if [ -d "$XB_PACKAGE_BASE" ]; then
    if [ -f "$XB_PACKAGE_BASE/etc/.postinstall.done" ]; then
        "Package \\\`$XB_BUILD_PKG' already installed in : \\\`$XB_PACKAGE_BASE'" >&2
        exit 17
    else
    (
        cd "$XB_PACKAGE_BASE"
        find . -type d -exec chmod 755 '{}' \;
    )
    fi
else
    "Unknown package base directory : \\\`$XB_PACKAGE_BASE'" >&2
    exit 20
fi

if [ ".\$LD_LIBRARY_PATH" = . ]; then
    LD_LIBRARY_PATH="$XB_PACKAGE_BASE/$libd"
else
    LD_LIBRARY_PATH="$XB_PACKAGE_BASE/$libd:\$LD_LIBRARY_PATH"
fi
export LD_LIBRARY_PATH

EOF
    chmod 755 "$XB_BUILD_ROOT$XB_PACKAGE_BASE/etc/.postinstall"

if [ ".$XB_BUILD_SYS" = ".windows" ]; then
    cat << EOF > "$XB_BUILD_ROOT$XB_PACKAGE_BASE/etc/postinstall.bat"
@echo off
rem Copyright(c) 2011 Red Hat, Inc.
rem
rem This is free software; you can redistribute it and/or
rem modify it under the terms of the GNU Lesser General Public
rem License as published by the Free Software Foundation; either
rem version 2 of the License, or (at your option) any later version.
rem
rem This software is distributed in the hope that it will be useful,
rem but WITHOUT ANY WARRANTY; without even the implied warranty of
rem MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
rem Lesser General Public License for more details.
rem
rem You should have received a copy of the GNU Lesser General Public
rem License along with this library in the file COPYING.LIB;
rem if not, write to the Free Software Foundation, Inc.,
rem 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
rem
rem $XB_BUILD_PPKG Post install script
rem

echo.
echo Starting $XB_PACKAGE_NAME post installation...
echo.
echo Version....... $XB_PACKAGE_VERSION
echo Revision...... $XB_PACKAGE_REV
echo.

if not exist ".postinstall.done" goto doPostinstall
echo Package $XB_PACKAGE_PKG already installed
goto endInstall

:doPostinstall
set INSTALL_ETC_DIR=%cd%
echo %DATE% %TIME% >".postinstall.done"
cd ..
set INSTALL_TOP_DIR=%cd%
pushd sbin
set INSTALL_SYS_DIR=%cd%
popd
pushd bin
set INSTALL_BIN_DIR=%cd%
popd
set PATH=%INSTALL_BIN_DIR%;%INSTALL_SYS_DIR%;%PATH%

EOF

fi

    cat << EOR > "$XB_BUILD_ROOT$XB_PACKAGE_BASE/BUILDSPEC"
Copyright(c) 2011 Red Hat Inc,
and individual contributors.

Package: $XB_PACKAGE_PPKG
Version: $XB_PACKAGE_VERSION
Revision: $XB_PACKAGE_REV
Platform: $XB_BUILD_SYS
Architecture: $XB_BUILD_CPU
Timestamp: `date +%Y%m%d%H%M%S`
Created-by: `$XB_OPT_CCV 2>&1 | head -1`
Build-number: ${BUILD_NUMBER:="unknown"}
EOR

    # Additional BUILDSPEC description
    cat "$XB_BUILD_PDIR/package.desc" >> "$XB_BUILD_ROOT$XB_PACKAGE_BASE/BUILDSPEC"
    if $xb_build_clist; then
        cat << EOR >> "$XB_BUILD_ROOT$XB_PACKAGE_BASE/BUILDSPEC"

Component list
EOR
    fi

    pbld="$XB_BUILD_TOP/$XB_BUILD_PKG"
    # Disabled by JBPAPP-6471
    # install -m 644 "$pbld/package.spec" "$XB_BUILD_ROOT$XB_PACKAGE_BASE/etc/"
    # install -m 644 "$pbld/package.list" "$XB_BUILD_ROOT$XB_PACKAGE_BASE/etc/"
    # Run makefiles
    $xb_progloc/xb.runmakefiles.sh "$pbld" "$XB_BUILD_PDIR" $@
    # TODO: Check for return values

    if $xb_build_dists; then
        xbstripbin "$XB_BUILD_ROOT$XB_PACKAGE_BASE/$libd"
        if [ -d "$XB_BUILD_PDIR/licenses" ]; then
            $XB_VERBOSE "Building licenses ..."
            xbcopypdir "$XB_BUILD_PDIR/licenses" \
                "$XB_BUILD_ROOT$XB_PACKAGE_BASE/doc/licenses"
        fi
    fi
    #
    # Fix directory and file permissions before creating tarballs
    #
    (
        cd "$XB_BUILD_ROOT$XB_PACKAGE_BASE"
        find . -type d -exec chmod 755 '{}' \;
        find . -type f -exec chmod g+r,o+r '{}' \;
    )
    if [ ".$XB_BUILD_SYS" = .solaris ]; then
        cat << EOF >> "$XB_BUILD_ROOT$XB_PACKAGE_BASE/etc/.postinstall"
#
# Configure Solaris runtime linker environment
#
if [ -x /usr/bin/crle ]; then
    /usr/bin/crle -u $crlo $XB_PACKAGE_BASE/$libd
fi
EOF
    else
        cat << EOF >> "$XB_BUILD_ROOT$XB_PACKAGE_BASE/etc/.postinstall"
#
# Configure dynamic linker run time bindings
#
if [ -x /sbin/ldconfig ]; then
    /sbin/ldconfig -n $XB_PACKAGE_BASE/$libd
fi
EOF
    fi
    cat << EOF >> "$XB_BUILD_ROOT$XB_PACKAGE_BASE/etc/.postinstall"

if [ "\$check_java_home" = "yes" ]; then
    if [ ".\$JAVA_HOME" = . ]; then
        echo ""

        echo "-----------------------------------------------------------------------"
        echo " NOTICE"
        echo "-----------------------------------------------------------------------"
        echo ""
        echo " JAVA_HOME environment variable is not set."
        echo " Either set the  JAVA_HOME  or edit the configuration"
        echo " scripts inside \\\`$XB_PACKAGE_BASE/etc/sysconfig' directory"
        echo " and set the JAVA_HOME to the installed JDK location."
        echo ""
    fi
fi

# End of $XB_BUILD_PKG Post install script
EOF

if [ ".$XB_BUILD_SYS" = ".windows" ]; then
    cat << EOF >> "$XB_BUILD_ROOT$XB_PACKAGE_BASE/etc/postinstall.bat"

if not "x%JAVA_HOME%x" == "xx" goto haveJavaHome

echo.
echo -----------------------------------------------------------------------
echo  NOTICE
echo -----------------------------------------------------------------------
echo.
echo  JAVA_HOME environment variable is not set.
echo  Either set the  JAVA_HOME  or edit the configuration
echo  scripts inside "C:$XB_PACKAGE_RWIN/XB_PACKAGE_BWIN/etc/sysconfig" directory
echo  and set the JAVA_HOME to the installed JDK location.
echo.

:haveJavaHome

:endInstall
echo.
echo [%DATE% %TIME%] Done
echo.
EOF
    chmod 755 "$XB_BUILD_ROOT$XB_PACKAGE_BASE/etc/postinstall.bat"
fi

    # Run platform postmake
    if $xb_build_dists; then
        xboverride "$xb_progloc/xb.postmake" "$pbld" "$XB_BUILD_PDIR" $@
        xboverride "$pbld/common/xb.postbld" "$pbld" "$XB_BUILD_PDIR" "$xb_progloc" $@
        if [ ".$XB_BUILD_SYS" = ".windows" ]; then
            $xb_progloc/xb.lineends.pl --cr "$XB_BUILD_ROOT$XB_PACKAGE_BASE/"
            $xb_progloc/xb.lineends.pl --cr "$XB_BUILD_ROOT$XB_PACKAGE_BASE/BUILDSPEC"
        else
            $xb_progloc/xb.lineends.pl --nocr --force "$XB_BUILD_ROOT$XB_PACKAGE_BASE/etc/"
            $xb_progloc/xb.lineends.pl --nocr --force "$XB_BUILD_ROOT$XB_PACKAGE_BASE/doc/"
        fi
    fi
    os_package="$XB_PACKAGE_DISTNAME-$XB_BUILD_SYS$XB_BUILD_VER-$XB_BUILD_CPU"
    pp_package="$XB_PACKAGE_DISTPATCH-$XB_BUILD_SYS$XB_BUILD_VER-$XB_BUILD_CPU"
    if $xb_build_suser; then
    (
        # Change the owner of the dist files
        $XB_VERBOSE -n "Changing file permissions to $xb_build_owner:$xb_build_group ... "
        cd "$XB_BUILD_ROOT"
        sudo chown -Rf $xb_build_owner:$xb_build_group opt
        $XB_VERBOSE "OK"
    )
    fi
    # Create binary tarballs
    if $xb_build_dists; then
    (
        cd "$XB_BUILD_ROOT"
        rm -rf $os_package.* >/dev/null 2>&1
        rm -rf $pp_package.* >/dev/null 2>&1
        if [ ".$XB_BUILD_SYS" = ".windows" ]; then
            rhbdir="$XB_PACKAGE_WNAM"
            $XB_VERBOSE "Skipping $os_package.tar.gz ..."
        else
            rhbdir="$XB_PACKAGE_UNAM"
            $XB_VERBOSE "Creating $os_package.tar.gz ..."
            $xb_progloc/xb.tarball.sh --gzip \
                --out="$XB_BUILD_ROOT" --wd="$XB_PACKAGE_ROOT" "$os_package" $rhbdir
            if $xb_build_bzip; then
                $XB_VERBOSE "Creating $os_package.tar.bz2 ..."
                $xb_progloc/xb.tarball.sh --bzip \
                    --out="$XB_BUILD_ROOT" --wd="$XB_PACKAGE_ROOT" "$os_package" $rhbdir
            fi
        fi

        # Create patch package from package.pbld
        if [ ".$XB_PACKAGE_PATCH" = "." ]; then
            $XB_VERBOSE "Skipping $pp_package.patch ..."
        else
            $XB_VERBOSE "Creating $pp_package ..."
		    $xb_progloc/xb.buildpatch.sh "$pbld" "$XB_BUILD_ROOT"
            if [ ".$XB_BUILD_SYS" = ".windows" ]; then
                $XB_VERBOSE "Creating windows $pp_package.zip ..."
                $xb_progloc/xb.tarball.sh --zip \
                    --out="$XB_BUILD_ROOT" --wd="$XB_BUILD_TDIR/$XB_PACKAGE_ROOT" "$pp_package" "\"$rhbdir\""
            else
                $XB_VERBOSE "Creating $pp_package.zip ..."
                $xb_progloc/xb.tarball.sh --zip \
                    --out="$XB_BUILD_ROOT" --wd="$XB_BUILD_TDIR/$XB_PACKAGE_ROOT" "$pp_package" $rhbdir
                $XB_VERBOSE "Creating $pp_package.tar.gz ..."
                $xb_progloc/xb.tarball.sh --gzip \
                    --out="$XB_BUILD_ROOT" --wd="$XB_BUILD_TDIR/$XB_PACKAGE_ROOT" "$pp_package" $rhbdir
            fi
        fi
        cd "$XB_BUILD_ROOT"
        if [ ".$XB_BUILD_SYS" = ".windows" ]; then
            $XB_VERBOSE "Creating windows $os_package.zip ..."
            $xb_progloc/xb.tarball.sh --zip \
                --out="$XB_BUILD_ROOT" --wd="$XB_PACKAGE_ROOT" "$os_package" "\"$rhbdir\""
        else
            $XB_VERBOSE "Creating $os_package-dev.zip ..."
            $xb_progloc/xb.tarball.sh --zip \
                --out="$XB_BUILD_ROOT" --wd="$XB_PACKAGE_ROOT" "$os_package" $rhbdir
        fi
        cd "$XB_BUILD_ROOT"
        if [ ".$XB_BUILD_SYS" = ".windows" ]; then
            $XB_VERBOSE "Skipping $os_package.bin ..."
        else
            $XB_VERBOSE "Creating $os_package.bin ..."
            $xb_progloc/xb.makeself.sh --gzip \
                --header="$pbld/package.mhdr" \
                --target="$XB_PACKAGE_BASE" "$XB_BUILD_ROOT$XB_PACKAGE_BASE" \
                "$os_package.bin" \
                "$os_package" "$XB_PACKAGE_BASE/etc/.postinstall"
        fi
        if [ ".$XB_PACKAGE_NATIVE" = .Y ]; then
            # Call OS custom package creation script
            xboverride $xb_progloc/xb.ospackage "$pbld" "$XB_BUILD_PDIR" \
                "$XB_BUILD_ROOT" "$os_package"
        fi
        # Sign packages
        cat /dev/null > MD5SUM
        sIFS=$IFS; IFS=$XB_LF
        if [ ".$XB_PACKAGE_PATCH" = "." ]; then
            for p in `ls -1 $os_package* 2>/dev/null`
            do
                $MD5SUM "$p" >> MD5SUM
            done
        else
            for p in `ls -1 $pp_package* 2>/dev/null`
            do
                $MD5SUM "$p" >> MD5SUM
            done
        fi
        IFS=$sIFS
    )
    fi
    # Move created tarballs to dist
    if [ ".$xb_build_type" = .daemon ]; then
        rm -rf $XB_DAEMON_ARTIFACTS_DIR/bin/$os_package* >/dev/null 2>&1 || true
        rm -rf $XB_DAEMON_ARTIFACTS_DIR/bin/$pp_package* >/dev/null 2>&1 || true
        if [ ".$XB_PACKAGE_PATCH" = "." ]; then
            mv $XB_BUILD_ROOT/$os_package* "$XB_DAEMON_ARTIFACTS_DIR/bin/" >/dev/null 2>&1 || true
        else
            mv $XB_BUILD_ROOT/$pp_package* "$XB_DAEMON_ARTIFACTS_DIR/bin/" >/dev/null 2>&1 || true
        fi
        mv "$XB_BUILD_ROOT/MD5SUM" "$XB_DAEMON_ARTIFACTS_DIR/bin/" >/dev/null 2>&1 || true
    else
        if [ ".$XB_PACKAGE_PATCH" = "." ]; then
            mv $XB_BUILD_ROOT/$os_package* "$XB_BUILD_DIST/" >/dev/null 2>&1 || true
        else
            mv $XB_BUILD_ROOT/$pp_package* "$XB_BUILD_DIST/" >/dev/null 2>&1 || true
        fi
        if [ -f "$XB_BUILD_ROOT/MD5SUM" ]; then
            cat "$XB_BUILD_ROOT/MD5SUM" >> "$XB_BUILD_DIST/MD5SUM"
        fi
    fi
    if $xb_build_nkeep; then
        eval "$rmcmd \"$XB_BUILD_ROOT/opt\" >/dev/null 2>&1 || true"
        eval "$rmcmd \"$XB_BUILD_ROOT/tmp\" >/dev/null 2>&1 || true"
    fi
    return 0
}

build_bindist $@
exit $?

